package gui;

import com.inet.jortho.SpellChecker;
import javax.swing.SwingUtilities;
import java.io.File;
import java.net.MalformedURLException;

/**
 * Main class of program. Implements singleton pattern.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class Program extends ActionBuilder {

	public Program() {
		super();
	}

	private static Program instance = null;

    private static void registerDictionaries() {
        File directory = new File("dictionaries");
        try {
            SpellChecker.registerDictionaries(directory.toURL(), "ar, de, en, es, fr, it, nl, pl, ru", "en");
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
	
	public static Program getInstance(String[] args) {
		if (instance == null) {
            registerDictionaries();
			instance = new Program();
			instance.buildMenuBar();
			instance.buildToolBar();
			instance.buildPopupMenu();
			instance.buildActions();
			instance.getPropertiesManager().loadProperties(args);
			instance.setVisible(true);
			instance.getTextEditor().getTextComponent().grabFocus();
		}
		return instance;
	}
	
	public static void main(String[] args) {
		final String[] commandLineArguments = args; 
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				getInstance(commandLineArguments);
			}
		});
	}

}
