package properties;

import gui.Application;
import java.io.*;

/**
 * PropertiesManager handles operations with properties.
 * Program use file of properties for persist settings in file system.
 * If file of properties is not exist will be used default settings. 
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class PropertiesManager {

	private static final String PROPERTIES_FILE_NAME = "properties.dat";
	
	private Application application = null;
    private EditorProperties properties = null;
	
	public PropertiesManager(Application application) {
		this.application = application;
	}
	
	/**
	 * Load properties. Establish program options.
	 * @param commandLineArguments - command line parameters that passed in main function 
	 */
	public void loadProperties(String[] commandLineArguments) {
        File propertiesFile = new File(PROPERTIES_FILE_NAME);
        ObjectInputStream stream = null;
        boolean isPropertiesLoaded = false;
        try {
            stream = new ObjectInputStream(new FileInputStream(propertiesFile));
            properties = (EditorProperties) stream.readObject();
            if (properties != null) isPropertiesLoaded = true;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (stream != null)
                try {
                    stream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
        }
        if (!isPropertiesLoaded) {
            properties = new EditorProperties();
        }
        properties.establishProperties(application, commandLineArguments);
    }
	
	/**
	 * Builds properties from current program settings and saves properties into file.
	 */
	public void saveProperties() {
        File propertiesFile = new File(PROPERTIES_FILE_NAME);
        ObjectOutputStream stream = null;
		try {
			properties.buildProperties(application);
            stream = new ObjectOutputStream(new FileOutputStream(propertiesFile));
            stream.writeObject(properties);;
		} catch (NullPointerException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
            if (stream != null)
                try {
                    stream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
        }
	}

}
