<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- package -->

    <xsl:template match="architecture/packages/package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="packages" />
            <xsl:apply-templates select="classes" />
            <xsl:apply-templates select="capsules" />
            <xsl:apply-templates select="diagrams" />
        </div>
    </xsl:template>

    <xsl:template match="package/packages/package">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="packages" />
            <xsl:apply-templates select="classes" />
            <xsl:apply-templates select="capsules" />
            <xsl:apply-templates select="diagrams" />
        </div>
    </xsl:template>

    <xsl:template match="package/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <!-- table of contents -->

    <xsl:template match="package" mode="table_of_contents">
        <xsl:if test="pd-package or cd-package or crc-package or specification or packages or classes or capsules or diagrams">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_architecture_package_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_interfaces" />
                <xsl:apply-templates select="." mode="table_of_contents_classes" />
                <xsl:apply-templates select="." mode="table_of_contents_capsules" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>