<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- database package -->

    <xsl:template match="database/database-package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="database-package" />
            <xsl:apply-templates select="types" />
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

    <xsl:template match="database-package/database-package">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="database-package" />
            <xsl:apply-templates select="types" />
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

    <xsl:template match="database-package" mode="table_of_contents">
        <xsl:if test="pd-package or database-package or types or diagram">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:if test="pd-package or database-package">
                    <li><a href="#{generate-id(.)}-overview" onclick="expandAncestors('{generate-id(.)}-overview')">Overview</a></li>
                </xsl:if>
                <xsl:if test="specification">
                    <li><a href="#{generate-id(specification)}-header"  onclick="expandAncestors('{generate-id(specification)}-header')">Specification</a></li>
                </xsl:if>
                <xsl:if test="database-package">
                    <li>Packages
                        <ul>
                            <xsl:for-each select="database-package">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                        <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
                <xsl:if test="types">
                    <li><a href="#{generate-id(types)}-header" onclick="expandAncestors('{generate-id(types)}-header')">Types</a></li>
                </xsl:if>
                <xsl:if test="diagram">
                    <li>Diagrams
                        <ul>
                            <xsl:for-each select="diagram">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                        <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="database-package/description">
        <h4>Description</h4>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="database-package/types">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Types</h4>
        <ul id="{generate-id(.)}" class="attributes">
            <xsl:apply-templates />
        </ul>
    </xsl:template>

    <xsl:template match="database-package/diagram">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

</xsl:stylesheet>