<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
	<!-- GUI -->
	
	<xsl:template match="analysis" mode="table_of_contents_gui">
		<xsl:if test="gui">
			<li>
				<a href="#gui" onclick="expandAncestors('gui')">GUI</a>
				<ul>
					<xsl:if test="gui/pd-package or gui/gui-package">
						<li><a href="#gui-overview" onclick="expandAncestors('gui-overview')">Overview</a></li>
					</xsl:if>
					<xsl:if test="gui/specification">
						<li><a href="#{generate-id(gui/specification)}-header"  onclick="expandAncestors('{generate-id(gui/specification)}-header')">Specification</a></li>
					</xsl:if>
					<xsl:if test="gui/gui-package">
						<li>Packages 
							<ul>
								<xsl:for-each select="gui/gui-package">
									<li>
										<xsl:choose>
											<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
											<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
					<xsl:if test="gui/menu">
						<li><a href="#menu-header" onclick="expandAncestors('menu-header')">Menu</a></li>
					</xsl:if>
					<xsl:if test="gui/toolbar">
						<li><a href="#toolbar-header" onclick="expandAncestors('toolbar-header')">Toolbar</a></li>
					</xsl:if>
					<xsl:if test="gui/screen">
						<li>Screens 
							<ul>
								<xsl:for-each select="gui/screen">
									<xsl:choose>
										<xsl:when test="@id"><li><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></li></xsl:when>
										<xsl:otherwise><li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></li></xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="gui">
		<h2 id="gui">GUI</h2>
		<xsl:apply-templates select="description" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="gui-package" />
		<xsl:if test="menu">
			<h3 id="menu-header" onclick="toggleTag('menu')">Menu</h3>
			<ul id="menu" class="menu">
				<xsl:apply-templates select="menu" />
			</ul>
		</xsl:if>
		<xsl:if test="toolbar">
			<h3 id="toolbar-header" onclick="toggleTag('toolbar')">Toolbar</h3>
			<ul id="toolbar" class="toolbar">
				<xsl:apply-templates select="toolbar" />
			</ul>
		</xsl:if>
		<xsl:apply-templates select="screen" />
	</xsl:template>

	<xsl:template match="gui/description">
		<h3>Description</h3>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>	

	<xsl:template match="gui/specification">
		<h3 id="{generate-id(.)}-header" onclick="toggleSpecification('{generate-id(.)}')">Specification</h3>
		<ol id="{generate-id(.)}" state="hidden" class="specification" style="display:none">
			<xsl:apply-templates />
		</ol>
	</xsl:template>
	
	<xsl:template match="menu">
		<li><xsl:value-of select="." /></li>
	</xsl:template>
		
	<xsl:template match="toolbar">
		<li><xsl:value-of select="." /></li>
	</xsl:template>
		
	<xsl:template match="gui/screen">
		<xsl:choose>
			<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:when>
			<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}">
		  <img alt="{@name}" src="{@image}" style="float:left; padding-right:10px" />
		  <div style="display:inline">
			  <xsl:apply-templates />
		  </div>
		  <br style="clear:left" />
		</div>
	</xsl:template>

</xsl:stylesheet>
