<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- common view -->

    <xsl:template match="pattern" mode="table_of_contents_common_view">
        <li><a href="#{generate-id(solution/common-view)}-header" onclick="expandAncestors('{generate-id(solution/common-view)}-header')">Common view</a>
            <xsl:if test="solution/common-view/diagrams or solution/common-view/gui or solution/common-view/classes">
                <ul>
                    <xsl:apply-templates select="solution/common-view" mode="table_of_contents_overview" />
                    <xsl:apply-templates select="solution/common-view" mode="table_of_contents_diagrams" />
                    <xsl:apply-templates select="solution/common-view" mode="table_of_contents_gui" />
                    <xsl:apply-templates select="solution/common-view" mode="table_of_contents_interfaces" />
                    <xsl:apply-templates select="solution/common-view" mode="table_of_contents_classes" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="common-view">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Common view</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(diagrams) and not(gui) and not(classes)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="overview" />
                    <xsl:apply-templates select="diagrams" />
                    <xsl:apply-templates select="gui" />
                    <xsl:apply-templates select="classes" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="common-view/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="common-view/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>