<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- package -->

    <!-- top level -->

    <xsl:template match="package" mode="table_of_contents">
        <xsl:if test="specification or packages or diagrams or patterns">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_patterns" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="catalog/packages/package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <!-- inner package -->

    <xsl:template match="package/packages/package">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="package" mode="content">
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="packages" />
            <xsl:apply-templates select="diagrams" />
            <xsl:apply-templates select="patterns" />
        </div>
    </xsl:template>

</xsl:stylesheet>
