<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- pattern -->

    <xsl:template match="catalog | package" mode="table_of_contents_patterns">
        <xsl:if test="patterns">
            <li>
                <xsl:choose>
                    <xsl:when test="count(patterns/pattern) = 1"><a href="#{generate-id(patterns)}">Pattern</a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(patterns)}">Patterns</a></xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="patterns/pattern">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="catalog/patterns">
        <xsl:choose>
            <xsl:when test="count(pattern) > 1"><h2 id="{generate-id(.)}">Patterns</h2></xsl:when>
            <xsl:when test="count(pattern) = 1"><h2 id="{generate-id(.)}">Pattern</h2></xsl:when>
        </xsl:choose>
        <xsl:apply-templates select="pattern" />
    </xsl:template>

    <xsl:template match="patterns">
        <xsl:apply-templates select="pattern" />
    </xsl:template>

    <xsl:template match="catalog/patterns/pattern">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="pattern">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="pattern" mode="name">
        Pattern : <xsl:value-of select="@name" />
        <xsl:if test="alias">
            also known as
            <xsl:for-each select="alias">
                <xsl:choose>
                    <xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
                </xsl:choose>
                <xsl:if test="position() != last()"> , </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template match="pattern" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(specification) and  not(context) and not(problem) and not(motives) and not(solution) and not(consequences) and not(relation)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="table_of_contents" />
                    <xsl:apply-templates select="specification" />
                    <xsl:apply-templates select="context" />
                    <xsl:apply-templates select="problem" />
                    <xsl:apply-templates select="motives" />
                    <xsl:apply-templates select="solution" />
                    <xsl:apply-templates select="implementation" />
                    <xsl:apply-templates select="consequences" />
                    <xsl:apply-templates select="relation" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="pattern/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="pattern/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="pattern" mode="table_of_contents">
        <h4>Table of contents</h4>
        <ul class="contents">
            <xsl:apply-templates select="." mode="table_of_contents_specification" />
            <xsl:if test="context">
                <li><a href="#{generate-id(context)}-header" onclick="expandAncestors('{generate-id(context)}-header')">Context</a></li>
            </xsl:if>
            <xsl:if test="problem">
                <li><a href="#{generate-id(problem)}-header" onclick="expandAncestors('{generate-id(problem)}-header')">Problem</a></li>
            </xsl:if>
            <xsl:if test="motives">
                <li><a href="#{generate-id(motives)}-header" onclick="expandAncestors('{generate-id(motives)}-header')">Motives</a></li>
            </xsl:if>
            <xsl:if test="solution">
                <li><a href="#{generate-id(solution)}-header" onclick="expandAncestors('{generate-id(solution)}-header')">Solution</a>
                    <ul>
                        <xsl:apply-templates select="." mode="table_of_contents_common_view" />
                        <xsl:apply-templates select="." mode="table_of_contents_views" />
                    </ul>
                </li>
            </xsl:if>
            <xsl:if test="implementation">
                <li><a href="#{generate-id(implementation)}-header" onclick="expandAncestors('{generate-id(implementation)}-header')">Implementation</a></li>
            </xsl:if>
            <xsl:if test="consequences">
                <li><a href="#{generate-id(consequences)}-header" onclick="expandAncestors('{generate-id(consequences)}-header')">Consequences</a></li>
            </xsl:if>
            <xsl:if test="relation">
                <li><a href="#{generate-id(relation)}-header" onclick="expandAncestors('{generate-id(relation)}-header')">Relation</a></li>
            </xsl:if>
        </ul>
    </xsl:template>

    <xsl:template match="context">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Context</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="problem">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Problem</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="motives">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Motives</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="motive">
        <ul class="motives"><li><xsl:apply-templates /></li></ul>
    </xsl:template>

    <xsl:template match="solution">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Solution</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="common-view" />
            <xsl:apply-templates select="view" />
        </div>
    </xsl:template>

    <xsl:template match="implementation">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Implementation</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="consequences">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Consequences</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="consequence">
        <ul class="consequences"><li><xsl:apply-templates /></li></ul>
    </xsl:template>

    <xsl:template match="relation">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Relation</h4>
        <div id="{generate-id(.)}" class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>