<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- variable -->

	<xsl:template match="data">
		<h4>Data</h4>
		<ul class="attributes">
			<xsl:apply-templates select="variable" />
		</ul>
	</xsl:template>
	
	<xsl:template match="data/variable">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" />	</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="data/variable" mode="content">
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as 
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer</xsl:when>
					<xsl:when test="@primitive = 'real'"> real</xsl:when>
					<xsl:when test="@primitive = 'object'"> object</xsl:when>
					<xsl:when test="@primitive = 'character'"> character</xsl:when>
					<xsl:when test="@primitive = 'string'"> string</xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean</xsl:when>
					<xsl:when test="@primitive = 'class'"> class</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="variable">
				is ( 
				<xsl:apply-templates select="variable" />
				) 						
			</xsl:when>
			<xsl:when test="@value">
				is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="@purpose"><em class="comment"> { Purpose : <xsl:value-of select="@purpose" /> } </em></xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="variable/variable | element/variable | property/variable">
		<xsl:choose>
			<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
			<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as 
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="variable">
				is 
				<span onclick="toggleVariable('{generate-id(.)}', '{generate-id(.)}-content')"> ( </span>
				<span id="{generate-id(.)}-content" style="display:inline" onclick="toggleVariable('{generate-id(.)}', '{generate-id(.)}-content')"> ... </span>
				<span id="{generate-id(.)}" style="display:none">
					<xsl:apply-templates select="variable" />
				</span>
				<span onclick="toggleVariable('{generate-id(.)}', '{generate-id(.)}-content')"> ) </span>
			</xsl:when>
			<xsl:when test="@value">
				is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="@purpose"><em class="comment"> { Purpose : <xsl:value-of select="@purpose" /> } </em></xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>		
		<xsl:if test="position() != last()"> , </xsl:if>		
	</xsl:template>
	
	<!-- constant -->
	
	<xsl:template match="constants">
		<h4>Constants</h4>
		<ul class="attributes">
			<xsl:apply-templates select="constant" />
		</ul>
	</xsl:template>

	<xsl:template match="constant">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="constant" mode="content">
		<xsl:if test="@name">
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@name and @type">
				 as 
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@name and @primitive">
				as 
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@name and constant">
				is ( 
				<xsl:apply-templates select="constant" />
				) 
			</xsl:when>
			<xsl:when test="@name and @value">
				 is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>	
	</xsl:template>

	<xsl:template match="constant/constant | enumeration/constant | enumeration-constant-element/constant">
		<xsl:choose>
			<xsl:when test="@name or @value or constant">
				<xsl:if test="@name">
					<xsl:choose>
						<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
						<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="@name and @type">
						as 
						<xsl:choose>
							<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
							<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="@name and @primitive">
						as 
						<xsl:choose>
							<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
							<xsl:when test="@primitive = 'real'"> real </xsl:when>
							<xsl:when test="@primitive = 'object'"> object </xsl:when>
							<xsl:when test="@primitive = 'character'"> character </xsl:when>
							<xsl:when test="@primitive = 'string'"> string </xsl:when>
							<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
							<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
							<xsl:when test="@primitive = 'class'"> class </xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="constant">
						<xsl:if test="@name">  is </xsl:if>
						<span onclick="toggleConstant('{generate-id(.)}', '{generate-id(.)}-content')"> ( </span>
						<span id="{generate-id(.)}-content" style="display:inline" onclick="toggleConstant('{generate-id(.)}', '{generate-id(.)}-content')"> ... </span>
						<span id="{generate-id(.)}" style="display:none">
							<xsl:apply-templates select="constant" />
						</span>
						<span onclick="toggleConstant('{generate-id(.)}', '{generate-id(.)}-content')"> ) </span>
					</xsl:when>
					<xsl:when test="@value">
						<xsl:if test="@name">  is </xsl:if>
						<xsl:choose>
							<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
							<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
						</xsl:choose>		
					</xsl:when>
				</xsl:choose>
				<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
				<xsl:if test="position() != last()"> , </xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : constant is not defined } </em>
				<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
				<xsl:if test="position() != last()"> , </xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>