<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

    <!-- participation -->

    <xsl:template match="participant">
        <tr>
            <td><xsl:value-of select="position()" /></td>
            <td><xsl:apply-templates select="." mode="content" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="participant" mode="content">
        <xsl:choose>
            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@use-case" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@use-case" /></xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="@role = 'primary'"> in primary role </xsl:when>
            <xsl:when test="@role = 'secondary'"> in secondary role </xsl:when>
            <xsl:when test="@role = 'both'"> in both roles </xsl:when>
        </xsl:choose>
        <xsl:if test="@goal"> with the goal of <xsl:value-of select="@goal" /> </xsl:if>
        <xsl:if test="@result"> for <xsl:value-of select="@result" /> </xsl:if>
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

</xsl:stylesheet>