<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- shared pools -->

	<xsl:template match="shared-pools">
		<h4 onclick="toggleTag('{generate-id(.)}')">Shared pools</h4>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="." mode="classes" />
			<xsl:apply-templates select="." mode="types" />
			<xsl:apply-templates select="." mode="constants" />
			<xsl:apply-templates select="." mode="data" />
			<xsl:apply-templates select="." mode="operations" />
		</div>
	</xsl:template>
	
	<xsl:template match="shared-pools" mode="classes">
		<xsl:variable name="canPerform1" select="//class/@id = share/@reference" />
		<xsl:variable name="canPerform2" select="//interface/@id = share/@reference" />
		<xsl:variable name="canPerform" select="$canPerform1 or $canPerform2" />
		<xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-classes')">Classes</h4>
			<ul id="{generate-id(.)}-classes" class="attributes">
				<xsl:for-each select="share">
					<xsl:variable name="id" select="@id" />
					<xsl:variable name="reference" select="@reference" />
					<xsl:for-each select="//class[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//interface[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>

	<xsl:template match="shared-pools" mode="types">
		<xsl:variable name="canPerform1" select="//record/@id = share/@reference" />
		<xsl:variable name="canPerform2" select="//array/@id = share/@reference" />
		<xsl:variable name="canPerform3" select="//interval/@id = share/@reference" />
		<xsl:variable name="canPerform4" select="//primitive/@id = share/@reference" />
		<xsl:variable name="canPerform5" select="//set/@id = share/@reference" />
		<xsl:variable name="canPerform6" select="//enumeration/@id = share/@reference" />
		<xsl:variable name="canPerform7" select="//file/@id = share/@reference" />
		<xsl:variable name="canPerform8" select="//list/@id = share/@reference" />
		<xsl:variable name="canPerform9" select="//stack/@id = share/@reference" />
		<xsl:variable name="canPerform10" select="//hashtable/@id = share/@reference" />
		<xsl:variable name="canPerform11" select="//type/@id = share/@reference" />
		<xsl:variable name="canPerform12" select="//tree/@id = share/@reference" />
		<xsl:variable name="canPerform13" select="//queue/@id = share/@reference" />
		<xsl:variable name="canPerform" select="$canPerform1 or $canPerform2 or $canPerform3 or $canPerform4 or $canPerform5 or $canPerform6 or $canPerform7 or $canPerform8 or $canPerform9 or $canPerform10 or $canPerform11 or $canPerform12 or $canPerform13" />
		<xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-types')">Types</h4>
			<ul id="{generate-id(.)}-types" class="attributes">
				<xsl:for-each select="share">
					<xsl:variable name="id" select="@id" />
					<xsl:variable name="reference" select="@reference" />
					<xsl:for-each select="//type[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//primitive[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//file[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//array[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//list[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//queue[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//stack[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//set[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//hashtable[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//interval[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//enumeration[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//tree[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//record[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>

	<xsl:template match="shared-pools" mode="constants">
		<xsl:variable name="canPerform1" select="//constant/@id = share/@reference" />
		<xsl:variable name="canPerform2" select="//enumeration-constant-element/@id = share/@reference" />
		<xsl:variable name="canPerform" select="$canPerform1 or $canPerform2" />
		<xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-constants')">Constants</h4>
			<ul id="{generate-id(.)}-constants" class="attributes">
				<xsl:for-each select="share">
					<xsl:variable name="id" select="@id" />
					<xsl:variable name="reference" select="@reference" />
					<xsl:for-each select="//enumeration-constant-element[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//constant[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template match="shared-pools" mode="data">
		<xsl:variable name="canPerform1" select="//variable/@id = share/@reference" />
		<xsl:variable name="canPerform2" select="//element/@id = share/@reference" />
		<xsl:variable name="canPerform3" select="//property/@id = share/@reference" />
		<xsl:variable name="canPerform" select="$canPerform1 or $canPerform2 or $canPerform3" />
		<xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-data')">Data</h4>
			<ul id="{generate-id(.)}-data" class="attributes">
				<xsl:for-each select="share">
					<xsl:variable name="id" select="@id" />
					<xsl:variable name="reference" select="@reference" />
					<xsl:for-each select="//variable[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//element[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//property[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template match="shared-pools" mode="operations">
		<xsl:variable name="canPerform1" select="//function/@id = share/@reference" />
		<xsl:variable name="canPerform2" select="//test-procedure/@id = share/@reference" />
		<xsl:variable name="canPerform3" select="//constructor/@id = share/@reference" />
		<xsl:variable name="canPerform4" select="//destructor/@id = share/@reference" />
		<xsl:variable name="canPerform5" select="//method/@id = share/@reference" />
		<xsl:variable name="canPerform6" select="//operator/@id = share/@reference" />
		<xsl:variable name="canPerform7" select="//thread/@id = share/@reference" />
		<xsl:variable name="canPerform" select="$canPerform1 or $canPerform2 or $canPerform3 or $canPerform4 or $canPerform5 or $canPerform6 or $canPerform7" />
		<xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-operations')">Operations</h4>
			<ul id="{generate-id(.)}-operations" class="attributes">
				<xsl:for-each select="share">
					<xsl:variable name="id" select="@id" />
					<xsl:variable name="reference" select="@reference" />
					<xsl:for-each select="//function[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//constructor[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//destructor[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//method[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//operator[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//thread[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
					<xsl:for-each select="//test-procedure[@id = $reference]">
						<xsl:apply-templates select="." mode="shared_pools">
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="reference" select="$reference" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>