<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- types -->

    <xsl:template match="types">
        <h4>Types</h4>
        <ul class="attributes">
            <xsl:apply-templates />
        </ul>
    </xsl:template>

	<xsl:template match="type | primitive | file | array | list | queue | stack | set | hashtable | interval | enumeration | tree">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="type" mode="content">
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@definition">
				 is 
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@definition" /></a> </xsl:when>
					<xsl:otherwise><xsl:value-of select="@definition" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@type">
				 is 
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a> </xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : type is not defined } </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>	
	</xsl:template>
	
	<xsl:template match="primitive" mode="content">
		<xsl:value-of select="@name" /> is 
		<xsl:choose>
			<xsl:when test="@type = 'integer'">integer</xsl:when>
			<xsl:when test="@type = 'real'">real</xsl:when>
			<xsl:when test="@type = 'object'">object</xsl:when>
			<xsl:when test="@type = 'character'">character</xsl:when>
			<xsl:when test="@type = 'string'">string</xsl:when>
			<xsl:when test="@type = 'natural'">natural</xsl:when>
			<xsl:when test="@type = 'boolean'">boolean</xsl:when>
			<xsl:when test="@type = 'class'">class</xsl:when>
		</xsl:choose>
		<xsl:if test="@capacity">
			<xsl:choose>
				<xsl:when test="@type = 'string'"> with capacity of <xsl:value-of select="@capacity" /> characters </xsl:when>
				<xsl:otherwise> with capacity of <xsl:value-of select="@capacity" /> bytes </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="file" mode="content">
		<xsl:value-of select="@name" /> is file of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>	
	</xsl:template>
	
	<xsl:template match="array" mode="content">
		<xsl:value-of select="@name" /> is array 
		<xsl:for-each select="dimension">
			<xsl:choose>
				<xsl:when test="last() > 1 and  position() = 1"> with dimension </xsl:when>
				<xsl:when test="last() > 1 and position() != 1"> and dimension </xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@type"> 
					of 
					<xsl:choose>
						<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
					</xsl:choose>
					type
				</xsl:when>
				<xsl:when test="@capacity">
					with capacity of 
					<xsl:choose>
						<xsl:when test="@reference-to-capacity"><a href="#{@reference-to-capacity}" onclick="expandAncestors('{@reference-to-capacity}')"><xsl:value-of select="@capacity" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@capacity" /></xsl:otherwise>
					</xsl:choose> 
					elements
				</xsl:when>
				<xsl:when test="@minimum and @maximum">
					from  
					<xsl:choose>
						<xsl:when test="@reference-to-minimum"><a href="#{@reference-to-minimum}" onclick="expandAncestors('{@reference-to-minimum}')"><xsl:value-of select="@minimum" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@minimum" /></xsl:otherwise>
					</xsl:choose>
					to  
					<xsl:choose>
						<xsl:when test="@reference-to-maximum"><a href="#{@reference-to-maximum}" onclick="expandAncestors('{@reference-to-maximum}')"><xsl:value-of select="@maximum" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@maximum" /></xsl:otherwise>
					</xsl:choose>
					elements 
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>	
	</xsl:template>
	
	<xsl:template match="list" mode="content">
		<xsl:value-of select="@name" /> is list of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="queue" mode="content">
		<xsl:value-of select="@name" /> is queue of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>	
	</xsl:template>
	
	<xsl:template match="stack" mode="content">
		<xsl:value-of select="@name" /> is stack of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="set" mode="content">
		<xsl:value-of select="@name" /> is set of 
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="hashtable" mode="content">
		<xsl:value-of select="@name" /> is hashtable with 
		<xsl:choose>
			<xsl:when test="@reference-to-type-of-key"><a href="#{@reference-to-type-of-key}" onclick="expandAncestors('{@reference-to-type-of-key}')"><xsl:value-of select="@type-of-key" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type-of-key" /> </xsl:otherwise>
		</xsl:choose>
		type of key and 
		<xsl:choose>
			<xsl:when test="@reference-to-type-of-value"><a href="#{@reference-to-type-of-value}" onclick="expandAncestors('{@reference-to-type-of-value}')"><xsl:value-of select="@type-of-value" /> </a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type-of-value" /> </xsl:otherwise>
		</xsl:choose>
		type of value 
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="interval" mode="content">
		<xsl:value-of select="@name" /> is interval 
		from 
		<xsl:choose>
			<xsl:when test="@reference-to-minimum"><a href="#{@reference-to-minimum}" onclick="expandAncestors('{@reference-to-minimum}')"><xsl:value-of select="@minimum" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@minimum" /></xsl:otherwise>
		</xsl:choose>
		to 
		<xsl:choose>
			<xsl:when test="@reference-to-maximum"><a href="#{@reference-to-maximum}" onclick="expandAncestors('{@reference-to-maximum}')"><xsl:value-of select="@maximum" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@maximum" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>

	<xsl:template match="enumeration" mode="content">
		<xsl:value-of select="@name" /> is enumeration 
		(
			<xsl:apply-templates select="constant" />
		) 
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<xsl:template match="record">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
				<li id="{generate-id(.)}-end">end record</li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
				<li id="{generate-id(.)}-end">end record</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="record" mode="content">
		<xsl:choose>
			<xsl:when test="@reference">
				<a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name" /></a>
				<span onclick="toggleRecord('{generate-id(.)}', '{generate-id(.)}-end')" > is record </span>
			</xsl:when>
			<xsl:otherwise>
				<span onclick="toggleRecord('{generate-id(.)}', '{generate-id(.)}-end')" ><xsl:value-of select="@name" /> is record </span>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
		<ul id="{generate-id(.)}" style="list-style-type: none;padding-left: 1em;">
			<xsl:apply-templates />
		</ul>	
	</xsl:template>
	
	<xsl:template match="variants">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
				<li>end for feature</li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
				<li>end for feature</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="variants" mode="content">
		for feature <xsl:value-of select="@feature" />
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
		<ul style="list-style-type: none;padding-left: 1em;">
			<xsl:apply-templates select="variant" />
		</ul>	
	</xsl:template>
	
	<xsl:template match="variant">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
				<li id="{generate-id(.)}-end" style="display:none">end class</li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
				<li id="{generate-id(.)}-end" style="display:none">end class</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="variant" mode="content">
		<xsl:choose>
			<xsl:when test="@reference">
				<a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a>
				<span onclick="toggleRecord('{generate-id(.)}', '{generate-id(.)}-end')" > is class </span>
			</xsl:when>
			<xsl:otherwise>
				<span onclick="toggleRecord('{generate-id(.)}', '{generate-id(.)}-end')" ><xsl:value-of select="@class" /> is class </span>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
		<ul id="{generate-id(.)}" style="list-style-type: none;padding-left: 1em;display:none">
			<xsl:apply-templates />
		</ul>	
	</xsl:template>
	
	<xsl:template match="tree" mode="content">
		<xsl:value-of select="@name" /> is tree of 
		<xsl:choose>
			<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@power"> 
			with power of
			<xsl:choose>
				<xsl:when test="@reference-to-power"><a href="#{@reference-to-power}" onclick="expandAncestors('{@reference-to-power}')"><xsl:value-of select="@power" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@power" /></xsl:otherwise>
			</xsl:choose>
			elements  
		</xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
