<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- annotations -->
	
	<xsl:template match="annotations">
		<xsl:choose>
			<xsl:when test="count(annotation) = 1"><h4>Annotation</h4></xsl:when>
			<xsl:otherwise><h4>Annotations</h4></xsl:otherwise>
		</xsl:choose>
		<ul class="attributes">
			<xsl:apply-templates select="annotation" />
		</ul>
	</xsl:template>
	
	<xsl:template match="annotations/annotation">
		<li>
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="annotation">
					is (
					<xsl:apply-templates select="annotation" />
					)
				</xsl:when>
				<xsl:when test="@value">
					is <xsl:value-of select="@value" />
				</xsl:when>
			</xsl:choose>
		</li>
	</xsl:template>

	<!-- inner annotation -->
	
	<xsl:template match="annotation/annotation">
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="annotation">
				is (
				<xsl:apply-templates select="annotation" />
				)
			</xsl:when>
			<xsl:when test="@value">
				is <xsl:value-of select="@value" />
			</xsl:when>
		</xsl:choose>
		<xsl:if test="position() != last()"> , </xsl:if>
	</xsl:template>
	
</xsl:stylesheet>