<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- functions header -->
	
	<xsl:template match="function" mode="function_header">
		<xsl:choose>
			<xsl:when test="returns"> Function : </xsl:when>
			<xsl:otherwise> Procedure : </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>
	
	<xsl:template match="test-procedure" mode="test_procedure_header">
		Test procedure : 
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>		
	
	<xsl:template match="constructor" mode="constructor_header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'package'"> package </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		constructor
		<xsl:if test="@name">
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>
	
	<xsl:template match="destructor" mode="destructor_header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'package'"> package </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		destructor
		<xsl:if test="@name">
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>
	
	<xsl:template match="method" mode="method_header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'package'"> package </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@abstract = 'yes'"> abstract </xsl:when>
			<xsl:when test="@final = 'yes'"> final </xsl:when>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		method 
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>
	
	<xsl:template match="operator" mode="operator_header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'package'"> package </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		operator 
		<xsl:value-of select="@signature" />
		<xsl:if test="@name">
			named as 
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:if test="@priority">
			with priority 
			<xsl:value-of select="@priority" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>
	
	<xsl:template match="thread" mode="thread_header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'package'"> package </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>	
		<xsl:choose>
			<xsl:when test="@abstract = 'yes'"> abstract </xsl:when>
			<xsl:when test="@final = 'yes'"> final </xsl:when>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>		
		thread 
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="annotations" mode="header" />
	</xsl:template>

    <xsl:template match="thread" mode="top_thread_header">
        Thread :
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="@abstract = 'yes'"> abstract </xsl:when>
            <xsl:when test="@final = 'yes'"> final </xsl:when>
        </xsl:choose>
        <xsl:if test="@modifiers">
            <xsl:value-of select="' '" />
            <xsl:value-of select="@modifiers" />
            <xsl:value-of select="' '" />
        </xsl:if>
        <xsl:value-of select="@name" />
        <xsl:apply-templates select="annotations" mode="header" />
    </xsl:template>

</xsl:stylesheet>