<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- inner classes -->

	<xsl:template match="interface" mode="inner_interface">
		<xsl:choose>
			<xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="interface_header" /></h4></xsl:when>
			<xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="interface_header" /></h4></xsl:otherwise>
		</xsl:choose>	
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>
	
	<xsl:template match="interface" mode="content">
		<div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(definition) and not(specification) and not(responsibilities) and not(annotations) and not(implements) and not(parameterized-types) and not(contract) and not(method) and not(thread) and not(diagrams)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="definition" />
                    <xsl:apply-templates select="." mode="overview" />
                    <xsl:apply-templates select="specification" />
                    <xsl:apply-templates select="responsibilities" />
                    <xsl:apply-templates select="annotations" />
                    <xsl:apply-templates select="." mode="implementation" />
                    <xsl:apply-templates select="parameterized-types" />
                    <xsl:apply-templates select="contract" />
                    <xsl:if test="method">
                        <xsl:choose>
                            <xsl:when test="count(method) > 1"><h4>Methods</h4></xsl:when>
                            <xsl:otherwise><h4>Method</h4></xsl:otherwise>
                        </xsl:choose>
                        <ul class="attributes">
                            <xsl:apply-templates select="method" />
                        </ul>
                    </xsl:if>
                    <xsl:if test="thread">
                        <xsl:choose>
                            <xsl:when test="count(thread) > 1"><h4>Threads</h4></xsl:when>
                            <xsl:otherwise><h4>Thread</h4></xsl:otherwise>
                        </xsl:choose>
                        <ul class="attributes">
                            <xsl:apply-templates select="thread" />
                        </ul>
                    </xsl:if>
                    <xsl:apply-templates select="diagrams" />
                </xsl:otherwise>
            </xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="class" mode="inner_class">
		<xsl:choose>
			<xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="class_header" /></h4></xsl:when>
			<xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="class_header" /></h4></xsl:otherwise>
		</xsl:choose>		
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>
	
	<xsl:template match="class" mode="content">
		<div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(definition) and not(specification) and not(responsibilities) and not(annotations) and not(extends) and not(implements) and not(parameterized-types) and not(contract) and not(feature) and not(class-protocol) and not(instance-protocol) and not(diagrams) and not(test-procedures)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="definition" />
                    <xsl:apply-templates select="." mode="overview" />
                    <xsl:apply-templates select="specification" />
                    <xsl:apply-templates select="responsibilities" />
                    <xsl:apply-templates select="annotations" />
                    <xsl:apply-templates select="extends" />
                    <xsl:apply-templates select="." mode="implementation" />
                    <xsl:apply-templates select="parameterized-types" />
                    <xsl:apply-templates select="contract" />
                    <xsl:apply-templates select="feature" />
                    <xsl:apply-templates select="class-protocol" />
                    <xsl:apply-templates select="instance-protocol" />
                    <xsl:apply-templates select="diagrams" />
                    <xsl:apply-templates select="test-procedures/test-procedure" />
                </xsl:otherwise>
            </xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="classes">
		<h4 onclick="toggleGroup('{generate-id(.)}')">Classes</h4>
		<div class="indent"  id="{generate-id(.)}" style="collapsed">
			<xsl:apply-templates />
		</div>
	</xsl:template>

	<xsl:template match="interface">
		<xsl:apply-templates select="." mode="inner_interface" />
	</xsl:template>	
	
	<xsl:template match="class">
		<xsl:apply-templates select="." mode="inner_class" />
	</xsl:template>	

	<!-- content of classes -->
		
	<xsl:template match="interface/description | class/description | feature/description">
		<h4>Description</h4>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>

    <xsl:template match="interface/description | class/description | feature/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

	<xsl:template match="interface/definition | class/definition">
		<h4>Definition</h4>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>
	
	<xsl:template match="interface/responsibilities | class/responsibilities | feature/responsibilities">
		<xsl:if test="responsibility">
			<xsl:choose>
				<xsl:when test="count(responsibility) = 1"><h4>Responsibility</h4></xsl:when>
				<xsl:otherwise><h4>Responsibilities</h4></xsl:otherwise>
			</xsl:choose>
			<ul class="attributes">
				<xsl:apply-templates select="responsibility" />
			</ul>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="interface/responsibilities/responsibility | class/responsibilities/responsibility | feature/responsibilities/responsibility">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="extends">
		<h4>Extends class</h4>
		<div class="indent">
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@superclass" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@superclass" /></xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	
	<xsl:template match="interface | class" mode="implementation">
		<xsl:if test="implements">
			<xsl:choose>
				<xsl:when test="count(implements) = 1"><h4>Implements interface</h4></xsl:when>
				<xsl:otherwise><h4>Implements interfaces</h4></xsl:otherwise>
			</xsl:choose>
			<ul class="attributes">
				<xsl:apply-templates select="implements" />
			</ul>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="interface/implements | class/implements">
		<li>
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@interface" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@interface" /></xsl:otherwise>
			</xsl:choose>
	    </li>
	</xsl:template>
	
	<xsl:template match="feature">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Feature : <xsl:value-of select="@name" /></h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Feature : <xsl:value-of select="@name" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(specification) and not(responsibilities) and not(contract) and not(feature) and not(class-protocol) and not(instance-protocol) and not(diagrams) and not(test-procedures)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="specification" />
                    <xsl:apply-templates select="responsibilities" />
                    <xsl:apply-templates select="contract" />
                    <xsl:apply-templates select="feature" />
                    <xsl:apply-templates select="class-protocol" />
                    <xsl:apply-templates select="instance-protocol" />
                    <xsl:apply-templates select="diagrams" />
                    <xsl:apply-templates select="test-procedures/test-procedure" />
                </xsl:otherwise>
            </xsl:choose>
		</div>
	</xsl:template>
	
</xsl:stylesheet>
