<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- class overview -->

	<xsl:template match="class" mode="overview">
		<!-- ECE -->
		<xsl:variable name="canPerformECE1" select="class-protocol/attributes/enumeration-constant-elements or instance-protocol/attributes/enumeration-constant-elements" />
		<xsl:variable name="canPerformECE2" select=".//feature/class-protocol/attributes/enumeration-constant-elements" />
		<xsl:variable name="canPerformECE3" select=".//feature/instance-protocol/attributes/enumeration-constant-elements" />
		<xsl:variable name="canPerformECE" select="$canPerformECE1 or $canPerformECE2 or $canPerformECE3" />
		<!-- ASDA -->
		<xsl:variable name="canPerformASDA1" select="class-protocol/attributes/elements" />
		<xsl:variable name="canPerformASDA2" select="instance-protocol/attributes/elements" />	
		<xsl:variable name="canPerformASDA3" select=".//feature/class-protocol/attributes/elements" />	
		<xsl:variable name="canPerformASDA4" select=".//feature/instance-protocol/attributes/elements" />	
		<xsl:variable name="canPerformASDA5" select="class-protocol/attributes/properties" />
		<xsl:variable name="canPerformASDA6" select="instance-protocol/attributes/properties" />	
		<xsl:variable name="canPerformASDA7" select=".//feature/class-protocol/attributes/properties" />	
		<xsl:variable name="canPerformASDA8" select=".//feature/instance-protocol/attributes/properties" />		
		<xsl:variable name="canPerformASDA" select="$canPerformASDA1 or $canPerformASDA2 or $canPerformASDA3 or $canPerformASDA4 or $canPerformASDA5 or $canPerformASDA6 or $canPerformASDA7 or $canPerformASDA8" />
		<!-- MSD -->
		<xsl:variable name="canPerformMSD1" select="class-protocol/operations or instance-protocol/operations" />
		<xsl:variable name="canPerformMSD2" select=".//feature/class-protocol/operations" />
		<xsl:variable name="canPerformMSD3" select=".//feature/instance-protocol/operations" />
		<xsl:variable name="canPerformMSD" select="$canPerformMSD1 or $canPerformMSD2 or $canPerformMSD3" />
        <!-- TPSD -->
        <xsl:variable name="canPerformTPSD1" select="test-procedures" />
        <xsl:variable name="canPerformTPSD2" select=".//feature/test-procedures" />
        <xsl:variable name="canPerformTPSD" select="$canPerformTPSD1 or $canPerformTPSD2" />
        <!-- CDA -->
        <xsl:variable name="canPerformCD1" select="class-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD2" select="instance-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD3" select=".//feature/class-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD4" select=".//feature/instance-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD" select="$canPerformCD1 or $canPerformCD2 or $canPerformCD3 or $canPerformCD4" />
        <!-- CAPD -->
        <xsl:variable name="canPerformCAPD1" select="class-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCAPD2" select="instance-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCAPD3" select=".//feature/class-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCAPD4" select=".//feature/instance-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCAPD" select="$canPerformCAPD1 or $canPerformCAPD2 or $canPerformCAPD3 or $canPerformCAPD4" />
        <xsl:variable name="canPerform" select="$canPerformMSD or $canPerformECE or $canPerformASDA or $canPerformTPSD or $canPerformCD or $canPerformCAPD" />
        <xsl:if test="$canPerform">
			<h4 onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
			<div id="{generate-id(.)}-overview" class="indent" style="display:none">
                 <xsl:apply-templates select="." mode="overview_content" />
			</div>
		</xsl:if>
	</xsl:template>

    <!-- content -->

    <xsl:template match="class" mode="overview_content">
        <xsl:apply-templates select="." mode="overview_capsules" />
        <xsl:apply-templates select="." mode="overview_classes" />
        <xsl:apply-templates select="." mode="overview_enumerations" />
        <xsl:apply-templates select="." mode="overview_attributes" />
        <xsl:apply-templates select="." mode="overview_operations" />
        <xsl:apply-templates select="." mode="overview_test_procedures" />
    </xsl:template>

</xsl:stylesheet>