<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- class - responsibilities - collaboration -->

    <xsl:template match="interface" mode="crc">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="." mode="responsibilities_overview" />
            </td>
            <td>
                <xsl:apply-templates select="." mode="collaboration_overview" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="interface" mode="responsibilities_overview">
        <xsl:choose>
            <xsl:when test="not(responsibilities) or not(responsibilities/responsibility)">
                <br />
            </xsl:when>
            <xsl:otherwise>
                <ul class="responsibilities">
                    <xsl:apply-templates select="responsibilities/responsibility" mode="overview" />
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="responsibility" mode="overview">
        <li><xsl:apply-templates /></li>
    </xsl:template>

    <xsl:template match="interface" mode="collaboration_overview">
        <xsl:choose>
            <xsl:when test="not(implements) and not(annotations) and not(parameterized-types)">
                <br />
            </xsl:when>
            <xsl:otherwise>
                <ul class="collaboration">
                    <xsl:for-each select="implements">
                        <li>
                            Implements
                            <xsl:choose>
                                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@interface" /></a></xsl:when>
                                <xsl:otherwise><xsl:value-of select="@interface" /></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:if test="annotations">
                        <xsl:for-each select="annotations/annotation">
                            <li>
                                Annotated as
                                <xsl:apply-templates select="." mode="overview" />
                            </li>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="parameterized-types">
                        <xsl:for-each select="parameterized-types/parameterized-type">
                            <li>
                                Parameterized by
                                <xsl:apply-templates select="." mode="overview" />
                            </li>
                        </xsl:for-each>
                    </xsl:if>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="annotations/annotation" mode="overview">
        <xsl:choose>
            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="annotation">
                is (
                <xsl:apply-templates select="annotation" />
                )
            </xsl:when>
            <xsl:when test="@value">
                is <xsl:value-of select="@value" />
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="parameterized-types/parameterized-type" mode="overview">
        <xsl:value-of select="@name" />
        <xsl:if test="@type">
            <xsl:choose>
                <xsl:when test="@reference"> extends <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
                <xsl:otherwise> extends <xsl:value-of select="@type" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="class" mode="crc">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="." mode="responsibilities_overview" />
            </td>
            <td>
                <xsl:apply-templates select="." mode="collaboration_overview" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="class" mode="responsibilities_overview">
        <xsl:variable name="canPerform" select=".//feature/responsibilities/responsibility or responsibilities/responsibility" />
        <xsl:choose>
            <xsl:when test="$canPerform">
                <ul class="responsibilities">
                    <xsl:apply-templates select="responsibilities/responsibility" mode="overview" />
                    <xsl:apply-templates select="feature" mode="responsibilities_overview" />
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <br />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="feature" mode="responsibilities_overview">
        <xsl:variable name="canPerform" select=".//feature/responsibilities/responsibility or responsibilities/responsibility" />
        <xsl:if test="$canPerform">
            <h4>
                Feature :
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </h4>
            <div class="indent">
                <ul class="responsibilities">
                    <xsl:apply-templates select="responsibilities/responsibility" mode="overview" />
                    <xsl:apply-templates select="feature" mode="responsibilities_overview" />
                </ul>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="class" mode="collaboration_overview">
        <xsl:variable name="canPerform1" select="extends or implements or annotations or parameterized-types" />
        <xsl:variable name="canPerform2" select="class-protocol/attributes/classes/interface or class-protocol/attributes/classes/class or instance-protocol/attributes/classes/interface or instance-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform3" select=".//feature/class-protocol/attributes/classes/interface" />
        <xsl:variable name="canPerform4" select=".//feature/class-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform5" select=".//feature/instance-protocol/attributes/classes/interface" />
        <xsl:variable name="canPerform6" select=".//feature/instance-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform7" select="class-protocol/attributes/elements/element/@type and class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform8" select="instance-protocol/attributes/elements/element/@type and instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform9" select=".//feature/class-protocol/attributes/elements/element/@type and .//feature/class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform10" select=".//feature/instance-protocol/attributes/elements/element/@type and .//feature/instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform11" select="class-protocol/attributes/properties/property/@type and class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform12" select="instance-protocol/attributes/properties/property/@type and instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform13" select=".//feature/class-protocol/attributes/properties/property/@type and .//feature/class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform14" select=".//feature/instance-protocol/attributes/properties/property/@type and .//feature/instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform15" select="class-protocol/attributes/associations or instance-protocol/attributes/associations" />
        <xsl:variable name="canPerform16" select=".//feature/class-protocol/attributes/associations" />
        <xsl:variable name="canPerform17" select=".//feature/instance-protocol/attributes/associations" />
        <xsl:variable name="canPerform18" select="class-protocol/attributes/dependencies or instance-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform19" select=".//feature/class-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform20" select=".//feature/instance-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform" select="$canPerform1 or $canPerform2 or $canPerform3 or $canPerform4 or $canPerform5 or $canPerform6 or $canPerform7 or $canPerform8 or $canPerform9 or $canPerform10 or $canPerform11 or $canPerform12 or $canPerform13 or $canPerform14 or $canPerform15 or $canPerform16 or $canPerform17 or $canPerform18 or $canPerform19 or $canPerform20" />
        <xsl:choose>
            <xsl:when test="$canPerform">
                <ul class="collaboration">
                    <xsl:if test="extends">
                        <xsl:for-each select="extends">
                            <li>
                                Extends
                                <xsl:choose>
                                    <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@superclass" /></a></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="@superclass" /></xsl:otherwise>
                                </xsl:choose>
                            </li>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:for-each select="implements">
                        <li>
                            Implements
                            <xsl:choose>
                                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@interface" /></a></xsl:when>
                                <xsl:otherwise><xsl:value-of select="@interface" /></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:if test="annotations">
                        <xsl:for-each select="annotations/annotation">
                            <li>
                                Annotated as
                                <xsl:apply-templates select="." mode="overview" />
                            </li>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="parameterized-types">
                        <xsl:for-each select="parameterized-types/parameterized-type">
                            <li>
                                Parameterized by
                                <xsl:apply-templates select="." mode="overview" />
                            </li>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:for-each select="class-protocol/attributes/classes/interface">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/classes/class">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/classes/interface">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/classes/class">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/elements/element">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/elements/element">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/properties/property">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/properties/property">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/associations/association">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/associations/association">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/dependencies/dependency">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/dependencies/dependency">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:apply-templates select="feature" mode="collaboration_overview" />
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <br />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="feature" mode="collaboration_overview">
        <xsl:variable name="canPerform2" select="class-protocol/attributes/classes/interface or class-protocol/attributes/classes/class or instance-protocol/attributes/classes/interface or instance-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform3" select=".//feature/class-protocol/attributes/classes/interface" />
        <xsl:variable name="canPerform4" select=".//feature/class-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform5" select=".//feature/instance-protocol/attributes/classes/interface" />
        <xsl:variable name="canPerform6" select=".//feature/instance-protocol/attributes/classes/class" />
        <xsl:variable name="canPerform7" select="class-protocol/attributes/elements/element/@type and class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform8" select="instance-protocol/attributes/elements/element/@type and instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform9" select=".//feature/class-protocol/attributes/elements/element/@type and .//feature/class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform10" select=".//feature/instance-protocol/attributes/elements/element/@type and .//feature/instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerform11" select="class-protocol/attributes/properties/property/@type and class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform12" select="instance-protocol/attributes/properties/property/@type and instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform13" select=".//feature/class-protocol/attributes/properties/property/@type and .//feature/class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform14" select=".//feature/instance-protocol/attributes/properties/property/@type and .//feature/instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerform15" select="class-protocol/attributes/associations or instance-protocol/attributes/associations" />
        <xsl:variable name="canPerform16" select=".//feature/class-protocol/attributes/associations" />
        <xsl:variable name="canPerform17" select=".//feature/instance-protocol/attributes/associations" />
        <xsl:variable name="canPerform18" select="class-protocol/attributes/dependencies or instance-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform19" select=".//feature/class-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform20" select=".//feature/instance-protocol/attributes/dependencies" />
        <xsl:variable name="canPerform" select="$canPerform2 or $canPerform3 or $canPerform4 or $canPerform5 or $canPerform6 or $canPerform7 or $canPerform8 or $canPerform9 or $canPerform10 or $canPerform11 or $canPerform12 or $canPerform13 or $canPerform14 or $canPerform15 or $canPerform16 or $canPerform17 or $canPerform18 or $canPerform19 or $canPerform20" />
        <xsl:if test="$canPerform">
            <h4>
                Feature :
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </h4>
            <div class="indent">
                <ul class="collaboration">
                    <xsl:for-each select="class-protocol/attributes/classes/interface">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/classes/class">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/classes/interface">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/classes/class">
                        <li>
                            Composes
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/elements/element">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/elements/element">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/properties/property">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/properties/property">
                        <xsl:apply-templates select="." mode="overview_association" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/associations/association">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/associations/association">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="class-protocol/attributes/dependencies/dependency">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:for-each select="instance-protocol/attributes/dependencies/dependency">
                        <xsl:apply-templates select="." mode="overview" />
                    </xsl:for-each>
                    <xsl:apply-templates select="feature" mode="collaboration_overview" />
                </ul>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="element | property" mode="overview_association">
        <xsl:if test="@name-of-association and @type">
            <li>
                <xsl:if test="@role-of-class">
                    In role of <xsl:value-of select="@role-of-class" />
                </xsl:if>
                <xsl:value-of select="' '" />
                <xsl:value-of select="@name-of-association" />
                <xsl:value-of select="' '" />
                <xsl:value-of select="@cardinality" />
                <xsl:value-of select="' '" />
                <xsl:value-of select="@type" />
                <xsl:value-of select="' '" />
                <xsl:if test="@role-of-element">
                    in role of <xsl:value-of select="@role-of-element" />
                </xsl:if>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="association" mode="overview">
        <li> Assosiation :
            <xsl:apply-templates select="." mode="innerContent" />
        </li>
    </xsl:template>

    <xsl:template match="dependency" mode="overview">
        <li> Dependency <xsl:value-of select="@stereotype" /> :
            <xsl:apply-templates select="." mode="innerContent" />
        </li>
    </xsl:template>

</xsl:stylesheet>