<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- functions overview -->

    <xsl:template match="solution | implementation | package | model | realization | function | test-procedure | constructor | destructor | method | operator | thread | set-property | get-property | static" mode="overview_functions">
        <xsl:if test="functions">
            <table class="overview">
                <caption>Function - Signature / Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Signature / Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="functions/function" mode="fsd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="thread | set-property | get-property | static" mode="overview">
        <xsl:if test="capsules or classes or functions or threads">
            <h4 onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_capsules" />
                <xsl:apply-templates select="." mode="overview_classes" />
                <xsl:apply-templates select="." mode="overview_functions" />
                <xsl:apply-templates select="." mode="overview_threads" />
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="function | test-procedure | constructor | destructor | method | operator" mode="overview">
        <xsl:if test="capsules or classes or functions or threads">
            <h4 onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_capsules" />
                <xsl:apply-templates select="." mode="overview_classes" />
                <xsl:apply-templates select="." mode="overview_functions" />
                <xsl:apply-templates select="." mode="overview_threads" />
                <xsl:apply-templates select="." mode="overview_test_procedures" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- function - signature / description -->

    <xsl:template match="function" mode="fsd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="fsd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="fsd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="fsd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="function" mode="fsd_name">
        <xsl:choose>
            <xsl:when test="returns"> function </xsl:when>
            <xsl:otherwise> procedure </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="function" mode="short_signature">
        <xsl:value-of select="@name" />
        <xsl:apply-templates select="parameters" mode="header" />
        <xsl:apply-templates select="returns" mode="header" />
    </xsl:template>

    <xsl:template match="function/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>