<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- threads overview -->

    <xsl:template match="solution | implementation | package | model | realization | function | test-procedure | constructor | destructor | method | operator | thread | set-property | get-property | static" mode="overview_threads">
        <xsl:if test="threads">
            <table class="overview">
                <caption>Thread - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="threads/thread" mode="td"/>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- thread - description -->

    <xsl:template match="thread" mode="td">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="description" mode="td_overview" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="thread/description" mode="td_overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>