<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- packages -->

    <!-- solution, implementation, model -->

	<xsl:template match="solution | implementation | model | catalog" mode="table_of_contents_packages">
		<xsl:if test="packages">
			<li>
                <xsl:choose>
                    <xsl:when test="count(packages/package) > 1"><a href="#{generate-id(packages)}">Packages</a></xsl:when>
                    <xsl:when test="count(packages/package) = 1"><a href="#{generate-id(packages)}">Package</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="packages/package">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="solution/packages | implementation/packages | model/packages | catalog/packages">
        <xsl:choose>
            <xsl:when test="count(package) > 1"><h2 id="{generate-id(.)}">Packages</h2></xsl:when>
            <xsl:when test="count(package) = 1"><h2 id="{generate-id(.)}">Package</h2></xsl:when>
        </xsl:choose>
		<xsl:apply-templates select="package" />
	</xsl:template>

	<!-- architecture, level of package -->
	
	<xsl:template match="architecture | package | use-case | segment" mode="table_of_contents_packages">
		<xsl:if test="packages/package">
			<li>
                <xsl:choose>
                    <xsl:when test="count(packages/package) > 1">Packages</xsl:when>
                    <xsl:when test="count(packages/package) = 1">Package</xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="packages/package">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>	

	<xsl:template match="architecture/packages | package/packages | use-case/packages | segment/packages">
		<xsl:apply-templates select="package" />
	</xsl:template>
		
	<xsl:template match="package/description">
		<h4>Description</h4>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>

</xsl:stylesheet>