<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- aspects -->

    <xsl:template match="aspects">
        <h4 onclick="toggleTag('{generate-id(.)}')">Aspects</h4>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="application/aspects">
        <h4 onclick="toggleTag('{generate-id(.)}')">Aspects</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="precedent">
        <h4 onclick="toggleTag('{generate-id(.)}')">Precedent</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="viewpoint" />
            <xsl:apply-templates select="action" mode="aspect" />
            <xsl:apply-templates select="precondition" />
            <xsl:apply-templates select="postcondition" />
            <xsl:apply-templates select="algorithm" />
        </div>
    </xsl:template>

    <xsl:template match="reaction">
        <h4 onclick="toggleTag('{generate-id(.)}')">Reaction</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="viewpoint" />
            <xsl:apply-templates select="action" mode="aspect" />
            <xsl:apply-templates select="state" />
            <xsl:apply-templates select="algorithm" />
        </div>
    </xsl:template>

    <xsl:template match="aspect">
        <h4 onclick="toggleTag('{generate-id(.)}')">Aspect</h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="viewpoint" />
            <xsl:apply-templates select="action" mode="aspect" />
            <xsl:apply-templates select="algorithm" />
        </div>
    </xsl:template>

    <xsl:template match="precedent | reaction | aspect" mode="viewpoint">
        <xsl:if test="viewpoint">
            <xsl:choose>
                <xsl:when test="count(viewpoint) > 1"><h4>Viewpoints</h4></xsl:when>
                <xsl:otherwise><h4>Viewpoint</h4></xsl:otherwise>
            </xsl:choose>
            <ul class="viewpoints">
                <xsl:for-each select="viewpoint">
                    <li>
                        <xsl:choose>
                            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="." /></a></xsl:when>
                            <xsl:otherwise><xsl:value-of select="." /></xsl:otherwise>
                        </xsl:choose>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="action" mode="aspect">
        <h4>Action</h4>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>