<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- ramifications -->
	
	<!-- if -->
	
	<xsl:template match="if">
		<li> if <xsl:apply-templates select="condition" /> then 
			<xsl:apply-templates select="then" />
		</li>
		<xsl:apply-templates select="else-if" />
		<xsl:apply-templates select="else" />
		<li>end if</li>
	</xsl:template>
	
	<xsl:template match="then">
		<ol><xsl:apply-templates /></ol>
	</xsl:template>
	
	<xsl:template match="else-if">
		<li> else if <xsl:apply-templates select="condition" /> then 
			<xsl:apply-templates select="then" />
		</li>
	</xsl:template>
	
	<xsl:template match="else">
		<li> else
			<ol><xsl:apply-templates /></ol>
		</li>
	</xsl:template>

	<!-- select -->
	
	<xsl:template match="select">
		<li>select </li>
		<xsl:apply-templates select="accept" />
		<xsl:apply-templates select="when" />
		<xsl:apply-templates select="else" />
		<li> end select </li>
	</xsl:template>
	
	<xsl:template match="accept">
		<li> accept  
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@signal" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@signal" /></xsl:otherwise>
			</xsl:choose>
			do
			<ol><xsl:apply-templates /></ol>
		 </li>
	</xsl:template>
	
	<xsl:template match="when">
		<li> when <xsl:apply-templates select="condition" /> do 
			<ol><xsl:apply-templates /></ol>
		</li>
	</xsl:template>
	
	<!-- switch -->
	
	<xsl:template match="switch">
		<li> switch ( variable : 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@variable" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@variable" /></xsl:otherwise>
			</xsl:choose>
			)
		</li>
		<xsl:apply-templates select="case" />
		<xsl:apply-templates select="else" />
		<li> end switch </li>
	</xsl:template>
	
	<xsl:template match="case">
		<li>
			<xsl:if test="position() > 1"> else </xsl:if>
			case 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@value" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
			</xsl:choose>
			then
			<ol><xsl:apply-templates /></ol>
		</li>
	</xsl:template>
	
	<!-- resolve -->
	
	<xsl:template match="resolve">
		<li> resolve
			<ol>
				<xsl:apply-templates select="try" />
				<xsl:apply-templates select="catch" />
				<xsl:apply-templates select="finally" />
			</ol>
		</li>
		<li> end resolve </li>
	</xsl:template>
	
	<xsl:template match="try">
		<li> try
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end try </li>
	</xsl:template>
	
	<xsl:template match="catch">
		<li> catch (
			<xsl:choose>
				<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@exception" /></span></xsl:when>
				<xsl:otherwise><xsl:value-of select="@exception" /></xsl:otherwise>
			</xsl:choose>
			as
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
			</xsl:choose>
			)
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end catch </li>
	</xsl:template>
	
	<xsl:template match="finally">
		<li> finally
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end finally </li>
	</xsl:template>
	
	<!-- interaction -->
	
	<xsl:template match="interaction">
		<li>
			<span id="{generate-id(.)}-action"><a href="javascript:expandStep('{generate-id(.)}')">show <xsl:value-of select="@dialog" /> dialog</a></span> 
			<ol id="{generate-id(.)}-detailing" style="display:none">
				<li>
					interaction with 
					<xsl:choose>
						<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@dialog" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@dialog" /></xsl:otherwise>
					</xsl:choose>
					dialog
					<ol>
						<xsl:apply-templates select="choice" />
					</ol>
				</li>
				<li>end interaction</li>
			</ol>
		</li>
	</xsl:template>
	
	<xsl:template match="choice">
		<li> choice when <xsl:value-of select="@event" />
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end choice </li>
	</xsl:template>

</xsl:stylesheet>