<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- specific for use case -->

	<xsl:template match="include">
		<li>include
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@use-case" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@use-case" /></xsl:otherwise>
			</xsl:choose> 
			 
			use case
		</li>
	</xsl:template>
	
	<xsl:template match="extension-point">
		<xsl:choose>
			<xsl:when test="@id"><p id="{@id}" class="extension-point">extension point : <xsl:value-of select="@name" /></p></xsl:when>
			<xsl:otherwise><p class="extension-point">extension point : <xsl:value-of select="@name" /></p></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <!-- aspects of gui -->

    <xsl:template match="landmark">
        <span class="landmark"> [ <xsl:value-of select="." /> ] </span>
    </xsl:template>

    <xsl:template match="intensity">
        <span class="intensity"> { <xsl:value-of select="." /> } </span>
    </xsl:template>

    <xsl:template match="volume">
        <span class="volume"> ( <xsl:value-of select="." /> ) </span>
    </xsl:template>

    <xsl:template match="boundary">
        <xsl:choose>
            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><span class="boundary"> " <xsl:value-of select="." /> " </span></a></xsl:when>
            <xsl:otherwise><span class="boundary"> " <xsl:value-of select="." /> " </span></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
