<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
		
	<!-- test-scenarios -->
	
	<xsl:template match="solution | implementation | package | model | declaration | use-case | segment | domain" mode="table_of_contents_test_scenarios">
		<xsl:if test="test-scenarios">
			<li>
                <xsl:choose>
                    <xsl:when test="count(test-scenarios/test-scenario) > 1"><a href="#{generate-id(test-scenarios)}-header" onclick="expandAncestors('{generate-id(test-scenarios)}-header')">Test scenarios</a></xsl:when>
                    <xsl:when test="count(test-scenarios/test-scenario) = 1"><a href="#{generate-id(test-scenarios)}-header" onclick="expandAncestors('{generate-id(test-scenarios)}-header')">Test scenario</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="test-scenarios/test-scenario">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}" onclick="expandAncestors('{generate-id(.)}')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="solution/test-scenarios | implementation/test-scenarios | model/test-scenarios | domain/test-scenarios">
		<xsl:choose>
			<xsl:when test="count(test-scenario) > 1"><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenarios</h2></xsl:when>
			<xsl:when test="count(test-scenario) = 1"><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenario</h2></xsl:when>
		</xsl:choose>
        <div id="{generate-id(.)}">
    		<xsl:apply-templates select="test-scenario" />
        </div>
	</xsl:template>
    
	<xsl:template match="model/use-case/declaration/test-scenarios">
		<xsl:choose>
			<xsl:when test="count(test-scenario) > 1"><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenarios</h3></xsl:when>
			<xsl:when test="count(test-scenario) = 1"><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenario</h3></xsl:when>
		</xsl:choose>
		<div id="{generate-id(.)}">
			<xsl:apply-templates select="test-scenario" />
		</div>
	</xsl:template>
    
	<xsl:template match="package/test-scenarios | package/use-case/declaration/test-scenarios | use-case/use-case/declaration/test-scenarios | segment/declaration/test-scenarios | segment/use-case/declaration/test-scenarios">
		<xsl:choose>
			<xsl:when test="count(test-scenario) > 1"><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenarios</h4></xsl:when>
			<xsl:when test="count(test-scenario) = 1"><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test scenario</h4></xsl:when>
		</xsl:choose>
		<div id="{generate-id(.)}">
			<xsl:apply-templates select="test-scenario" />
		</div>
	</xsl:template>
		
    <xsl:template match="test-scenarios/test-scenario">
	<table class="test-scenario">
		<xsl:choose>
			<xsl:when test="@id"><caption id="{@id}"><xsl:value-of select="@name" /></caption></xsl:when>
			<xsl:otherwise><caption id="{generate-id(.)}"><xsl:value-of select="@name" /></caption></xsl:otherwise>
		</xsl:choose>
		<thead>
			<tr>
				<th>#</th>
				<th>Action</th>
				<th>Expected results</th>
			</tr>
		</thead>
		<tbody>
			<xsl:apply-templates select="test-step" />
		</tbody>
	</table>
  </xsl:template>
    
  <xsl:template match="test-step">
		<tr>
			<td><xsl:value-of select="position()" /></td>
			<td><xsl:apply-templates select="test-action" /></td>
			<td><xsl:apply-templates select="expected-results" /></td>
		</tr>
  </xsl:template>
  
  <xsl:template match="test-action">
	  <xsl:choose>
			<xsl:when test="parent::test-action">
				<xsl:choose>
					<xsl:when test="child::test-action"><li><ol class="nested-list"><xsl:apply-templates /></ol></li></xsl:when>
					<xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="child::test-action"><ol class="nested-list"><xsl:apply-templates /></ol></xsl:when>
					<xsl:otherwise><xsl:apply-templates /></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
  </xsl:template>
  
  <xsl:template match="expected-results">
        <xsl:choose>
            <xsl:when test="parent::expected-results">
                <xsl:choose>
                    <xsl:when test="child::expected-results"><li><ol class="nested-list"><xsl:apply-templates /></ol></li></xsl:when>
                    <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="child::expected-results"><ol class="nested-list"><xsl:apply-templates /></ol></xsl:when>
                    <xsl:otherwise><xsl:apply-templates /></xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
