<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- entities -->

    <xsl:template match="domain | package | use-case | segment" mode="table_of_contents_entities">
        <xsl:if test="entity">
            <li>
                <xsl:choose>
                    <xsl:when test="count(entity) = 1">Entity</xsl:when>
                    <xsl:otherwise>Entities</xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="entity">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain/entity">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="entity">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="entity" mode="content">
        <xsl:choose>
            <xsl:when test="description and not(specification) and not(owner) and not(responsibility) and not(entity-feature) and not(attribute) and not(association) and not(operation) and not(diagram)">
                <xsl:apply-templates select="description" mode="content" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="description" />
                <xsl:apply-templates select="specification" />
                <xsl:apply-templates select="." mode="owners" />
                <xsl:apply-templates select="." mode="responsibilities" />
                <xsl:apply-templates select="entity-feature" />
                <xsl:apply-templates select="." mode="attributes" />
                <xsl:apply-templates select="." mode="associations" />
                <xsl:apply-templates select="." mode="operations" />
                <xsl:apply-templates select="diagram" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="entity" mode="header">
        Entity :
        <xsl:value-of select="@name" />
        <xsl:if test="@extends">
            extends
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extends" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@extends" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="entity" mode="owners">
        <xsl:if test="owner">
            <h3>Owners</h3>
            <ol class="owners">
                <xsl:for-each select="owner">
                    <li>
                        <xsl:choose>
                            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@worker" /></a></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@worker" /></xsl:otherwise>
                        </xsl:choose>
                    </li>
                </xsl:for-each>
            </ol>
        </xsl:if>
    </xsl:template>

    <!-- feature -->

    <xsl:template match="entity-feature">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Feature : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Feature : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="." mode="responsibilities" />
            <xsl:apply-templates select="entity-feature" />
            <xsl:apply-templates select="." mode="attributes" />
            <xsl:apply-templates select="." mode="associations" />
            <xsl:apply-templates select="." mode="operations" />
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

</xsl:stylesheet>