<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- operations -->

    <xsl:template match="worker | worker-feature | entity | entity-feature" mode="operations">
        <xsl:if test="operation">
            <h3>Operations</h3>
            <div class="indent">
                <table class="protocol">
                    <thead>
                        <tr>
                            <th>name</th>
                            <th>description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="operation" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/operation | worker-feature/operation | entity/operation | entity-feature/operation">
        <xsl:choose>
            <xsl:when test="@id">
                <tr id="{@id}">
                    <td><xsl:apply-templates select="." mode="name" /></td>
                    <td>
                        <xsl:choose>
                            <xsl:when test="description and not(message) and not(parameters) and not(results) and not(attributes) and not(algorithm)">
                                <xsl:apply-templates select="description" mode="onlyDescription" />
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates select="." mode="description" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <td><xsl:apply-templates select="." mode="name" /></td>
                    <td>
                        <xsl:choose>
                            <xsl:when test="description and not(message) and not(parameters) and not(results) and not(attributes) and not(algorithm)">
                                <xsl:apply-templates select="description" mode="onlyDescription" />
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates select="." mode="description" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker/operation | worker-feature/operation | entity/operation | entity-feature/operation" mode="name">
        <xsl:value-of select="@name" />
        <xsl:if test="parameters">
            (
            <xsl:for-each select="parameters/parameter">
                <xsl:value-of select="@name" />
                <xsl:if test="@class">
                    as
                    <xsl:choose>
                        <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                        <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="position() != last()"> , </xsl:if>
            </xsl:for-each>
            )
        </xsl:if>
        <xsl:if test="results">
            as
            <xsl:for-each select="results/result">
                <xsl:choose>
                    <xsl:when test="@class">
                        <xsl:choose>
                            <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@name" />
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="position() != last()"> , </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/operation/description | worker-feature/operation/description | entity/operation/description | entity-feature/operation/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="worker/operation | worker-feature/operation | entity/operation | entity-feature/operation" mode="description">
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="message" />
        <xsl:apply-templates select="parameters" />
        <xsl:apply-templates select="results" />
        <xsl:apply-templates select="attributes" />
        <xsl:apply-templates select="algorithm" />
    </xsl:template>

    <xsl:template match="worker/operation/description | worker-feature/operation/description | entity/operation/description | entity-feature/operation/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="worker/operation/message | worker-feature/operation/message | entity/operation/message | entity-feature/operation/message">
        <h3>Message</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="worker/operation/parameters | worker-feature/operation/parameters | entity/operation/parameters | entity-feature/operation/parameters">
        <h3>Parameters</h3>
        <ul class="attributes">
            <xsl:apply-templates select="parameter" />
        </ul>
    </xsl:template>

    <xsl:template match="worker/operation/parameters/parameter | worker-feature/operation/parameters/parameter | entity/operation/parameters/parameter | entity-feature/operation/parameters/parameter">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
            </xsl:when>
            <xsl:otherwise>
                <li><xsl:apply-templates select="." mode="content" /></li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker/operation/parameters/parameter | worker-fetaure/operation/parameters/parameter | entity/operation/parameters/parameter | entity-fetaure/operation/parameters/parameter" mode="content">
        <xsl:value-of select="@name" />
        <xsl:if test="@class">
            as
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

    <xsl:template match="worker/operation/results | worker-feature/operation/results | entity/operation/results | entity-feature/operation/results">
        <h3>Results</h3>
        <ul class="attributes">
            <xsl:apply-templates select="result" />
        </ul>
    </xsl:template>

    <xsl:template match="worker/operation/results/result | worker-feature/operation/results/result | entity/operation/results/result | entity-feature/operation/results/result">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
            </xsl:when>
            <xsl:otherwise>
                <li><xsl:apply-templates select="." mode="content" /></li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker/operation/results/result | worker-feature/operation/results/result | entity/operation/results/result | entity-feature/operation/results/result" mode="content">
        <xsl:value-of select="@name" />
        <xsl:if test="@class">
            as
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

    <xsl:template match="worker/operation/attributes | worker-feature/operation/attributes | entity/operation/attributes | entity-feature/operation/attributes">
        <h3>Attributes</h3>
        <ul class="attributes">
            <xsl:apply-templates />
        </ul>
    </xsl:template>

    <xsl:template match="worker/operation/attributes/attribute | worker-feature/operation/attributes/attribute | entity/operation/attributes/attribute | entity-feature/operation/attributes/attribute">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
            </xsl:when>
            <xsl:otherwise>
                <li><xsl:apply-templates select="." mode="content" /></li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker/operation/attributes/attribute | worker-feature/operation/attributes/attribute | entity/operation/attributes/attribute | entity-feature/operation/attributes/attribute" mode="content">
        <xsl:value-of select="@name" />
        <xsl:if test="@class">
            as
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="child::node()"><em class="comment"> { Description : <xsl:apply-templates /> } </em></xsl:if>
    </xsl:template>

    <xsl:template match="worker/operation/attributes/dependency | worker-feature/operation/attributes/dependency | entity/operation/attributes/dependency | entity-feature/operation/attributes/dependency">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}"><xsl:apply-templates select="." mode="innerContent" /></li>
            </xsl:when>
            <xsl:otherwise>
                <li><xsl:apply-templates select="." mode="innerContent" /></li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker/operation/algorithm | worker-feature/operation/algorithm | entity/operation/algorithm | entity-feature/operation/algorithm">
        <h3 onclick="toggleAlgorithm('{generate-id(.)}')">Algorithm</h3>
        <ol id="{generate-id(.)}" state="collapsed" class="algorithm"><xsl:apply-templates /></ol>
    </xsl:template>

</xsl:stylesheet>