<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- concretization -->
	
	<xsl:template match="use-case | segment" mode="table_of_contents_concretization">
		<xsl:if test="concretization">
			<li><a href="#{generate-id(concretization)}-header" onclick="expandAncestors('{generate-id(.)}')">Concretization</a></li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="use-case/concretization | segment/concretization">
		<h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Concretization</h3>
		<div id="{generate-id(.)}">
			<xsl:apply-templates select="." mode="table" />
		</div>
	</xsl:template>

	<xsl:template match="concretization" mode="table">
		<table class="concretization">
			<thead>
				<tr>
					<th>#</th>
					<th>Abstract</th>
					<th>Concrete</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="term" />
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template match="term">
		<tr>
			<td><xsl:value-of select="position()" /></td>
			<td><xsl:apply-templates select="abstract" /></td>
			<td><xsl:apply-templates select="concrete" /></td>
		</tr>
	</xsl:template>
	
	<xsl:template match="abstract">
		<xsl:apply-templates />
	</xsl:template>
	  
	<xsl:template match="concrete">
		<xsl:apply-templates />
	 </xsl:template>
	
</xsl:stylesheet>
