<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- emotions -->

    <xsl:template match="iteration" mode="table_of_contents_emotions">
        <xsl:if test="emotion">
            <li>Emotions
                <ul>
                    <xsl:for-each select="emotion">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')">
                                    <xsl:choose>
                                        <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                                        <xsl:otherwise>emotion # <xsl:value-of select="position()" /></xsl:otherwise>
                                    </xsl:choose>
                                </a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">
                                    <xsl:choose>
                                        <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                                        <xsl:otherwise>emotion # <xsl:value-of select="position()" /></xsl:otherwise>
                                    </xsl:choose>
                                </a></xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="emotion">
                                <ul>
                                    <xsl:apply-templates select="." mode="table_of_contents_emotions" />
                                </ul>
                            </xsl:if>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="emotion">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Emotion : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Emotion # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Emotion : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Emotion # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="change" />
            <xsl:apply-templates select="resolution" />
        </div>
    </xsl:template>

    <xsl:template match="change">
        <h3 onclick="toggleTag('{generate-id(.)}')">Change</h3>
        <div id="{generate-id(.)}" class="indent">
            <xsl:if test="task">
                <h3>Tasks</h3>
                <ol class="tasks">
                    <xsl:apply-templates select="task" />
                </ol>
            </xsl:if>
            <xsl:if test="risk">
                <h3>Risks</h3>
                <ol class="risks">
                    <xsl:apply-templates select="risk" />
                </ol>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="task | risk" mode="assignment">
        <xsl:if test="assignment">
            <h3 onclick="toggleTag('{generate-id(.)}-assignment')">Assignment</h3>
            <ul id="{generate-id(.)}-assignment" class="assignment">
                <xsl:apply-templates select="assignment" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="assignment">
        <li>
            Assigned to
            <xsl:choose>
                <xsl:when test="@reference">
                    <xsl:choose>
                        <xsl:when test="$out = 'file' and @page">
                            <a href="{@page}#{@reference}">
                                <xsl:value-of select="@position" />
                            </a>
                        </xsl:when>
                        <xsl:when test="$out = 'memory' and @document">
                            <a href="{@document}#{@reference}">
                                <xsl:value-of select="@position" />
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                                <xsl:value-of select="@position" />
                            </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@position" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="activity">
                <ul class="activities">
                    <xsl:apply-templates select="activity" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="resolution">
        <h3 onclick="toggleTag('{generate-id(.)}')">Resolution</h3>
        <ul id="{generate-id(.)}" class="resolution">
            <xsl:apply-templates select="activity" />
        </ul>
    </xsl:template>

</xsl:stylesheet>