<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- task -->

    <xsl:template match="task">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="resolution" />
                    <xsl:apply-templates select="." mode="assignment"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li id="{generate-id(.)}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="resolution" />
                    <xsl:apply-templates select="." mode="assignment"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="task/description">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="task" mode="attributes">
        <xsl:if test="@priority or @effort or @maximum-effort or @minimum-effort">
            <table class="attributes">
                <thead>
                    <tr>
                        <xsl:if test="@priority"><th>priority</th></xsl:if>
                        <xsl:if test="@minimum-effort"><th>min effort</th></xsl:if>
                        <xsl:if test="@maximum-effort"><th>max effort</th></xsl:if>
                        <xsl:if test="@effort"><th>effort</th></xsl:if>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <xsl:if test="@priority">
                            <xsl:choose>
                                <xsl:when test="@priority = 'mast_have'">
                                    <td>mast have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'should_have'">
                                    <td>should have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'could_have'">
                                    <td>could have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'want_to_have'">
                                    <td>want to have</td>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="@minimum-effort"><td><xsl:value-of select="@minimum-effort" /></td></xsl:if>
                        <xsl:if test="@maximum-effort"><td><xsl:value-of select="@maximum-effort" /></td></xsl:if>
                        <xsl:if test="@effort"><td><xsl:value-of select="@effort" /></td></xsl:if>
                    </tr>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="task" mode="tracing">
        <xsl:if test="traced-from-functional-requirement or traced-from-non-functional-requirement or traced-from-issue or traced-from-risk or traced-to-risk">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-from-functional-requirement" />
                <xsl:apply-templates select="traced-from-non-functional-requirement" />
                <xsl:apply-templates select="traced-from-issue" />
                <xsl:apply-templates select="traced-from-risk" />
                <xsl:apply-templates select="traced-to-risk" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="task/traced-from-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="task/traced-from-non-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="task/traced-from-issue">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="task/traced-from-risk">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="task/traced-to-risk">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>