<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- actors -->

    <xsl:template match="model | package" mode="table_of_contents_actors">
        <xsl:if test="actors/actor">
            <li>
                <xsl:choose>
                    <xsl:when test="count(actors/actor) = 1">
                        <xsl:choose>
                            <xsl:when test="local-name() = 'model'"><a href="#{generate-id(actors)}" onclick="expandAncestors('{generate-id(actors)}')">Actor</a></xsl:when>
                            <xsl:otherwise>Actor</xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="local-name() = 'model'"><a href="#{generate-id(actors)}" onclick="expandAncestors('{generate-id(actors)}')">Actors</a></xsl:when>
                            <xsl:otherwise>Actors</xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="actors/actor">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="model/actors">
        <h2 id="{generate-id(.)}">Actors</h2>
        <xsl:apply-templates select="actor" />
    </xsl:template>

    <xsl:template match="model/actors/actor">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="package/actors/actor">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="actor" mode="name">
        <xsl:value-of select="@name" />
        <xsl:if test="@extends">
            extends
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extends" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@extends" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="actor" mode="content">
        <xsl:choose>
            <xsl:when test="description and not(specification) and not(participation) and not(characteristics) and not(responsibilities) and not(communicate-associations)">
                <xsl:apply-templates select="description" mode="content" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="description" />
                <xsl:apply-templates select="specification" />
                <xsl:apply-templates select="goal" />
                <xsl:apply-templates select="participation" />
                <xsl:apply-templates select="characteristics" />
                <xsl:apply-templates select="responsibilities" />
                <xsl:apply-templates select="communicate-associations" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="actor/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="actor/description" mode="content">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="actor/goal">
        <h4>Goal</h4>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="actor/participation">
        <h4 onclick="toggleTag('{generate-id(.)}-participation')">Participation</h4>
        <div id="{generate-id()}-participation" class="indent">
            <table class="participation">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>participation</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="participant" />
                </tbody>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="actor/characteristics">
        <h4>Characteristics</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="actor/responsibilities">
        <h4>Responsibilities</h4>
        <ul class="attributes">
            <xsl:for-each select="responsibility">
                <xsl:choose>
                    <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
                    <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </ul>
    </xsl:template>

</xsl:stylesheet>
