<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
    <!-- use-case -->
    
	<xsl:template match="model | package | use-case | segment" mode="table_of_contents_use_case">
		<xsl:if test="use-case">
			<li>Use cases
				<ul>
					<xsl:for-each select="use-case">
						<li>
                            <div id="{generate-id(.)}-element" style="text-decoration:underline"><a onclick="expandUseCase('{generate-id(.)}')"><xsl:value-of select="@name" /></a></div>
                            <div id="{generate-id(.)}-content" style="display:none">
                                <xsl:choose>
                                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                </xsl:choose>
                                <xsl:if test="declaration or packages or segment or use-case or realization">
                                    <ul>
                                        <xsl:apply-templates select="." mode="table_of_contents_overview" />
                                        <xsl:apply-templates select="declaration" mode="table_of_contents_declaration" />
                                        <xsl:apply-templates select="." mode="table_of_contents_segments" />
                                        <xsl:apply-templates select="." mode="table_of_contents_use_case" />
                                        <xsl:apply-templates select="." mode="table_of_contents_packages" />
                                        <xsl:apply-templates select="realization" mode="table_of_contents_realization" />
                                    </ul>
                                </xsl:if>
                            </div>
						</li>	
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

    <xsl:template match="model/use-case">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}"><xsl:apply-templates select="." mode="name"/></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header"><xsl:apply-templates select="." mode="name"/></h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content"/>
    </xsl:template>

    <xsl:template match="model/use-case/use-case">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="use-case">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

	<xsl:template match="use-case | segment" mode="content">
        <xsl:apply-templates select="." mode="declaration" />
		<xsl:apply-templates select="segment" />
		<xsl:apply-templates select="use-case" />
		<xsl:apply-templates select="packages" />
        <xsl:apply-templates select="realization" />
	</xsl:template>

    <xsl:template match="use-case" mode="name">
        <xsl:choose>
            <xsl:when test="@type='abstract'">Abstract use case : </xsl:when>
            <xsl:when test="@type='concrete'">Concrete use case : </xsl:when>
            <xsl:otherwise>Use case : </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="@name" />
        <xsl:if test="@extends">
            extends
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extends" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@extends" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
