<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- use case actors -->

    <xsl:template match="scenario | alternative" mode="actors">
        <xsl:apply-templates select="." mode="primary-actors"/>
        <xsl:apply-templates select="." mode="secondary-actors"/>
    </xsl:template>

    <xsl:template match="scenario | alternative" mode="primary-actors">
        <xsl:choose>
            <xsl:when test="count(primary-actor) = 1"><h4>Primary actor</h4></xsl:when>
            <xsl:otherwise><h4>Primary actors</h4></xsl:otherwise>
        </xsl:choose>
        <div class="indent">
            <xsl:apply-templates select="primary-actor" />
        </div>
    </xsl:template>

    <xsl:template match="scenario | alternative" mode="secondary-actors">
        <xsl:if test="secondary-actor">
            <xsl:choose>
                <xsl:when test="count(secondary-actor) = 1"><h4>Secondary actor</h4></xsl:when>
                <xsl:otherwise><h4>Secondary actors</h4></xsl:otherwise>
            </xsl:choose>
            <div class="indent">
                <xsl:apply-templates select="secondary-actor" />
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="primary-actor | secondary-actor" >
        <xsl:choose>
            <xsl:when test="@id">
                <p id="{@id}" class="actor">
                    <xsl:choose>
                        <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name"/></a></xsl:when>
                        <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <p class="actor">
                    <xsl:choose>
                        <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name"/></a></xsl:when>
                        <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
                </p>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(position() = last())"> , </xsl:if>
    </xsl:template>

</xsl:stylesheet>
