<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- test strategies -->

    <xsl:template match="process | package" mode="table_of_contents_test_strategies">
        <xsl:if test="test-strategy">
            <li>Test strategies
                <ul>
                    <xsl:for-each select="test-strategy">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/test-strategy">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Test strategy : <xsl:value-of select="@name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test strategy : <xsl:value-of select="@name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="objective" />
            <xsl:apply-templates select="technique" />
            <xsl:apply-templates select="completion" />
            <xsl:apply-templates select="considerations" />
        </div>
    </xsl:template>

    <xsl:template match="package/test-strategy">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Test strategy : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Test strategy : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="objective" />
            <xsl:apply-templates select="technique" />
            <xsl:apply-templates select="completion" />
            <xsl:apply-templates select="considerations" />
        </div>
    </xsl:template>

    <xsl:template match="test-strategy/objective">
        <h3>Test objective</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="test-strategy/technique">
        <h3>Technique</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="test-strategy/completion">
        <h3>Completion criteria</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="test-strategy/considerations">
        <h3>Special considerations</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>