<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- workers -->

    <xsl:template match="process | package" mode="table_of_contents_workers">
        <xsl:if test="worker">
            <li>Workers
                <ul>
                    <xsl:for-each select="worker">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@position" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@position" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/worker">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Worker : <xsl:value-of select="@position" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Worker : <xsl:value-of select="@position" /></h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="worker">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Worker : <xsl:value-of select="@position" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Worker : <xsl:value-of select="@position" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="worker" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(responsibility) and not(diagram) and not(activity) and not(artifact)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="responsibilities" />
                    <xsl:apply-templates select="diagram" />
                    <xsl:apply-templates select="." mode="participation" />
                    <xsl:apply-templates select="artifact" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="worker/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="worker/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="worker" mode="responsibilities">
        <xsl:if test="responsibility">
            <xsl:choose>
                <xsl:when test="count(responsibility) = 1"><h3>Responsibility</h3></xsl:when>
                <xsl:otherwise><h3>Responsibilities</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="responsibilities">
                <xsl:apply-templates select="responsibility" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/responsibility">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="worker" mode="participation">
        <xsl:if test="activity">
            <h3>Participation</h3>
            <ul class="participation">
                <xsl:apply-templates select="activity" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
