<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <xsl:param name="out" as="xs:string" select="'memory'" />

	<xsl:template match="project">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<title><xsl:value-of select="@name" /> project blueprint</title>
				<link rel="stylesheet" type="text/css" href=".blueprint/css/project.css" />
                <xsl:choose>
                    <xsl:when test="$out = 'file'">
                        <script type="text/javascript">var startPage = '<xsl:value-of select="//document[1]/@page" />';</script>
                    </xsl:when>
                    <xsl:otherwise>
                        <script type="text/javascript">var startPage = '<xsl:value-of select="//document[1]/@file" />';</script>
                    </xsl:otherwise>
                </xsl:choose>
                <script type="text/javascript" src=".blueprint/js/project.js"></script>
			</head>
			<body onload="load()">
				<div id="main">
					<div id="content">
						<h1><xsl:value-of select="@name" /> project blueprint</h1>
						<div id="hide">
							<input type="button" onclick="hide()" value="Hide" title="hide panel" />
                            <input type="button" onclick="expand()" value="Expand" id="buttonExpand" title="expand panel" />
                            <input type="button" onclick="collapse()" value="Collapse" id="buttonCollapse" title="collapse panel" style="display:none" />
						</div>
						<h2 onclick="toggleDocumentList()">Documents</h2>
						<ul id="documentList" state="collapsed">
							<xsl:apply-templates />
						</ul>
					</div>
					<div id="doc">
						<iframe scrolling="auto" frameborder="0" id="frame" />
					</div>
				</div>			
			</body>
		</html>
	</xsl:template>

	<xsl:template match="package">
		<li><a href="javascript:toggleList('{generate-id(.)}')" title="{@name} package"><xsl:value-of select="@name" /></a>
			<ul id="{generate-id(.)}" class="package">
				<xsl:apply-templates />
			</ul>
		</li>
	</xsl:template>

	<xsl:template match="document">
		<xsl:choose>
			<xsl:when test="$out = 'file'">
				<li><a href="javascript:loadPage('{@page}')" title="{@page}"><xsl:value-of select=" @name" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="javascript:loadPage('{@file}')" title="{@file}"><xsl:value-of select=" @name" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
