<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="proposal/capabilities.xslt" />
    <xsl:include href="proposal/coOwners/coOwners.xslt" />
    <xsl:include href="proposal/coOwners/coOwner.xslt" />
    <xsl:include href="proposal/coOwners/profile.xslt" />
    <xsl:include href="proposal/coOwners/needs.xslt" />
    <xsl:include href="proposal/problems.xslt" />
    <xsl:include href="proposal/positions.xslt" />
    <xsl:include href="proposal/vision.xslt" />
    <xsl:include href="proposal/requirements/requirements.xslt" />
    <xsl:include href="proposal/requirements/requirement.xslt" />
    <xsl:include href="proposal/requirements/issues.xslt" />
    <xsl:include href="proposal/requirements/issue.xslt" />
    <xsl:include href="proposal/risks/risks.xslt" />
    <xsl:include href="proposal/risks/risk.xslt" />
    <xsl:include href="proposal/estimates.xslt" />
    <xsl:include href="proposal/glossary.xslt" />

    <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="proposal">
<html>
    <head>
        <xsl:choose>
            <xsl:when test="@name"><title>Proposal : <xsl:value-of select="@name" /></title></xsl:when>
            <xsl:otherwise><title>Proposal</title></xsl:otherwise>
        </xsl:choose>
        <link rel="stylesheet" type="text/css" href=".blueprint/css/proposal.css" />
        <xsl:for-each select="stylesheet-link">
            <link rel="stylesheet" type="text/css" href="{@href}" />
        </xsl:for-each>
        <script type="text/javascript" src=".blueprint/js/proposal.js"></script>
    </head>
    <body onload="goToHash()">
        <xsl:choose>
          <xsl:when test="@name"><h1>Proposal : <xsl:value-of select="@name" /></h1></xsl:when>
          <xsl:otherwise><h1>Proposal</h1></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="table_of_contents" />
        <xsl:apply-templates select="co-owners" />
        <xsl:apply-templates select="problem" />
        <xsl:apply-templates select="position" />
        <xsl:apply-templates select="capabilities" />
        <xsl:apply-templates select="vision" />
        <xsl:apply-templates select="functional-requirements" />
        <xsl:apply-templates select="non-functional-requirements" />
        <xsl:apply-templates select="issues" />
        <xsl:apply-templates select="risks" />
        <xsl:apply-templates select="." mode="estimates" />
        <xsl:apply-templates select="glossary" />
    </body>
</html>
  </xsl:template>

    <xsl:template match="proposal" mode="table_of_contents">
        <xsl:if test="capabilities or co-owners or problem or position or vision or functional-requirements or non-functional-requirements or issues or risks or glossary or estimates">
            <h2>Table of contents</h2>
            <ul class="contents">
                <xsl:apply-templates select="co-owners" mode="table_of_contents" />
                <xsl:apply-templates select="problem" mode="table_of_contents" />
                <xsl:apply-templates select="position" mode="table_of_contents" />
                <xsl:apply-templates select="capabilities" mode="table_of_contents" />
                <xsl:apply-templates select="vision" mode="table_of_contents" />
                <xsl:apply-templates select="functional-requirements" mode="table_of_contents" />
                <xsl:apply-templates select="non-functional-requirements" mode="table_of_contents" />
                <xsl:apply-templates select="issues" mode="table_of_contents" />
                <xsl:apply-templates select="risks" mode="table_of_contents" />
                <xsl:apply-templates select="." mode="table_of_contents_estimates" />
                <xsl:apply-templates select="glossary" mode="table_of_contents" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
