<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- needs -->

    <xsl:template match="co-owner/needs">
        <h3 onclick="toggleTag('{generate-id(.)}')">Needs</h3>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="need" />
        </div>
    </xsl:template>

    <xsl:template match="needs/need">
        <xsl:choose>
            <xsl:when test="@id">
                <h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Need <xsl:if test="@priority"> with <xsl:value-of select="@priority" /> priority </xsl:if></h3>
                <xsl:apply-templates select="." mode="content" />
            </xsl:when>
            <xsl:otherwise>
                <h3 onclick="toggleTag('{generate-id(.)}')">Need <xsl:if test="@priority"> with <xsl:value-of select="@priority" /> priority </xsl:if></h3>
                <xsl:apply-templates select="." mode="content" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="need" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="concerns or current-solution or proposed-solution or traced-to-problem">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="concerns" />
                    <xsl:apply-templates select="current-solution" />
                    <xsl:apply-templates select="proposed-solution" />
                    <xsl:apply-templates select="." mode="tracing" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" mode="content" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="need/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="need/description" mode="content">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="need/concerns">
        <h3>Concerns</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="need/current-solution">
        <h3>Current solution</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="need/proposed-solution">
        <h3>Proposed solution</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="need" mode="tracing">
        <xsl:if test="traced-to-problem">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-to-problem" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="traced-to-problem">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>