<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- positions -->

    <xsl:template match="position" mode="table_of_contents">
        <li>
            <xsl:choose>
                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')">Position</a></xsl:when>
                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Position</a></xsl:otherwise>
            </xsl:choose>
            <xsl:if test="position-package">
                <ul>
                    <xsl:apply-templates select="position-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="position-package" mode="table_of_contents">
        <li>
            <xsl:choose>
                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
            </xsl:choose>
            <xsl:if test="position-package">
                <ul>
                    <xsl:apply-templates select="position-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
            <xsl:if test="position/position-package">
                <ul>
                    <xsl:apply-templates select="position/position-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="position">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Position</h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Position</h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="position-package/position">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Position</h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Position</h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="position" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:variable name="onlyCategory" select="not(target-customer) and not(opportunity) and category and not(benefit) and not(competition) and not(differentiation) and not(position-package) and not(traced-from-problem) and not(traced-from-business-actor) and not(traced-from-worker) and not(traced-to-particularity)" as="xs:boolean" />
            <xsl:choose>
                <xsl:when test="$onlyCategory">
                    <xsl:apply-templates select="category" mode="onlyCategory" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="target-customer" />
                    <xsl:apply-templates select="opportunity" />
                    <xsl:apply-templates select="category" />
                    <xsl:apply-templates select="benefit" />
                    <xsl:apply-templates select="competition" />
                    <xsl:apply-templates select="differentiation" />
                    <xsl:apply-templates select="." mode="tracing" />
                    <xsl:apply-templates select="position-package" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="position/category" mode="onlyCategory">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="position/target-customer">
        <h3>Target customer</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position/opportunity">
        <h3>Opportunity</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position/category">
        <h3>Category</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position/benefit">
        <h3>Benefit</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position/competition">
        <h3>Competition</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position/differentiation">
        <h3>Differentiation</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="position" mode="tracing">
        <xsl:if test="traced-from-problem or traced-from-business-actor or traced-from-worker or traced-to-particularity">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-from-problem" />
                <xsl:apply-templates select="traced-from-business-actor" />
                <xsl:apply-templates select="traced-from-worker" />
                <xsl:apply-templates select="traced-to-particularity" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="traced-from-problem">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from problem
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="traced-from-business-actor">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from business actor <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from business actor <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from business actor <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="traced-from-worker">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from worker <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from worker <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from worker <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="traced-to-particularity">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="position-package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>