<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- issue -->

    <xsl:template match="issue">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li id="{generate-id(.)}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="issue/description">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="issue" mode="attributes">
        <xsl:if test="@priority or @status or @benefit or @effort or @stability or @target-release">
            <table class="attributes">
                <thead>
                    <tr>
                        <xsl:if test="@priority"><th>priority</th></xsl:if>
                        <xsl:if test="@status"><th>status</th></xsl:if>
                        <xsl:if test="@stability"><th>stability</th></xsl:if>
                        <xsl:if test="@benefit"><th>benefit</th></xsl:if>
                        <xsl:if test="@minimum-effort"><th>min effort</th></xsl:if>
                        <xsl:if test="@maximum-effort"><th>max effort</th></xsl:if>
                        <xsl:if test="@effort"><th>effort</th></xsl:if>
                        <xsl:if test="@target-release"><th>target release</th></xsl:if>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <xsl:if test="@priority">
                            <xsl:choose>
                                <xsl:when test="@priority = 'mast_have'">
                                    <td>mast have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'should_have'">
                                    <td>should have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'could_have'">
                                    <td>could have</td>
                                </xsl:when>
                                <xsl:when test="@priority = 'want_to_have'">
                                    <td>want to have</td>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="@status"><td><xsl:value-of select="@status" /></td></xsl:if>
                        <xsl:if test="@stability"><td><xsl:value-of select="@stability" /></td></xsl:if>
                        <xsl:if test="@benefit"><td><xsl:value-of select="@benefit" /></td></xsl:if>
                        <xsl:if test="@minimum-effort"><td><xsl:value-of select="@minimum-effort" /></td></xsl:if>
                        <xsl:if test="@maximum-effort"><td><xsl:value-of select="@maximum-effort" /></td></xsl:if>
                        <xsl:if test="@effort"><td><xsl:value-of select="@effort" /></td></xsl:if>
                        <xsl:if test="@target-release"><td><xsl:value-of select="@target-release" /></td></xsl:if>
                    </tr>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="issue" mode="tracing">
        <xsl:if test="traced-from-particularity or traced-to-risk or traced-to-term or traced-to-task or traced-to-use-case">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-from-particularity" />
                <xsl:apply-templates select="traced-to-risk" />
                <xsl:apply-templates select="traced-to-term" />
                <xsl:apply-templates select="traced-to-task" />
                <xsl:apply-templates select="traced-to-use-case" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="issue/traced-from-particularity">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from particularity
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="issue/traced-to-risk">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="issue/traced-to-term">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to term <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to term <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to term <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="issue/traced-to-task">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="issue/traced-to-use-case">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to use case <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to use case <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to use case <xsl:value-of select="@name" />
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>