<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="common/declarations/specification.xslt" />
    <xsl:include href="workspace/specification.xslt" />
    <xsl:include href="workspace/diagrams.xslt" />
    <xsl:include href="workspace/packages.xslt" />
    <xsl:include href="workspace/projects.xslt" />
    <xsl:include href="workspace/families.xslt" />
    <xsl:include href="workspace/overview/family.xslt" />
    <xsl:include href="workspace/overview/overview.xslt" />
    <xsl:include href="workspace/overview/package.xslt" />
    <xsl:include href="workspace/overview/project.xslt" />
    <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="workspace">
<html>
    <head>
        <xsl:choose>
            <xsl:when test="@name"><title>Workspace : <xsl:value-of select="@name" /></title></xsl:when>
            <xsl:otherwise><title>Workspace</title></xsl:otherwise>
        </xsl:choose>
        <link rel="stylesheet" type="text/css" href=".blueprint/css/workspace.css" />
        <xsl:for-each select="stylesheet-link">
            <link rel="stylesheet" type="text/css" href="{@href}" />
        </xsl:for-each>
        <script type="text/javascript" src=".blueprint/js/workspace.js"></script>
    </head>
    <body onload="goToHash()">
        <xsl:choose>
          <xsl:when test="@name"><h1>Workspace : <xsl:value-of select="@name" /></h1></xsl:when>
          <xsl:otherwise><h1>Workspace</h1></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="table_of_contents" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="specification" />
        <xsl:apply-templates select="package" />
        <xsl:apply-templates select="diagram" />
        <xsl:apply-templates select="family" />
        <xsl:apply-templates select="project" />
    </body>
</html>
  </xsl:template>

    <xsl:template match="workspace" mode="table_of_contents">
        <xsl:if test="specification or package or diagram or project or family">
            <h2>Table of contents</h2>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_families" />
                <xsl:apply-templates select="." mode="table_of_contents_projects" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace/description">
        <h2>Description</h2>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>
