<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- project - description -->

    <xsl:template match="workspace | package" mode="overview_projects">
        <xsl:if test="project">
            <table class="overview">
                <caption>Project - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="project" mode="pd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="project" mode="pd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="description" mode="onlyDescription" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="project/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>