/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.FqtCompletionDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class CompletionDialog
extends JDialog
implements KeyListener {
    DispatchData data;
    JScrollPane scrollPane;
    JTextArea textArea;
    String text;
    LinkedList history;
    String insertFile;
    int insertOffset;
    static CompletionDialog lastcDialog;
    int x;
    int y;
    int mx;
    int my;

    /*
     * WARNING - void declaration
     */
    public static void insertFqtCompletion(Buffer buffer, int offset, String ss) {
        int ii;
        int lastdot = -1;
        while ((ii = ss.indexOf(46, lastdot + 1)) != -1) {
            void var4_4;
            lastdot = var4_4;
        }
        if (lastdot < 0) {
            s.insertCompletion(buffer, offset, ss);
            return;
        }
        String pack = ss.substring(0, lastdot);
        String cl = ss.substring(lastdot + 1);
        new FqtCompletionDialog(pack, cl, buffer, offset);
    }

    public static void addImportAndInsertCompletion(String imp, Buffer buffer, int offset, String cl) {
        try {
            DispatchData ndata = new DispatchData(s.xbTask, (Component)s.view);
            XrefCharBuffer receipt = ndata.xTask.callProcessOnFileNoSaves(new String[]{"-olcxtrivialprecheck", "-getlastimportline"}, ndata);
            Dispatch.dispatch(receipt, ndata);
            int ln = Integer.parseInt(ndata.info);
            int off = buffer.getLineStartOffset(ln);
            String iinsertion = "import " + imp + "\n";
            buffer.insert(off, iinsertion);
            s.insertCompletion(buffer, offset + iinsertion.length(), cl);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String getPrefixOnCompletion() {
        int offset = s.getCaretPosition();
        int i = offset - 1;
        while (i > 0 && Character.isJavaIdentifierPart(s.getBuffer().getText(i, 1).charAt(0))) {
            --i;
        }
        return s.getBuffer().getText(++i, offset - i);
    }

    public static int charCount(String ss, char cc, int b, int e) {
        int i = b;
        int res = 0;
        while ((i = ss.indexOf(cc, i)) != -1 && i < e) {
            ++res;
            ++i;
        }
        return res;
    }

    int getCompletionLineNumber(int car) {
        int line = CompletionDialog.charCount(this.text, '\n', 0, car + 1);
        return line;
    }

    void displayProfileIfShouldBeDisplayed() {
        try {
            int car = this.textArea.getCaretPosition();
            int ln = this.textArea.getLineOfOffset(car);
            int lb = this.textArea.getLineStartOffset(ln);
            int le = this.textArea.getLineEndOffset(ln);
            String line = this.textArea.getText(lb, le - lb);
            int i = line.length() - 1;
            while (i >= 0) {
                if (line.charAt(i) == '(' && i < line.length() - 1 && i > 0 && line.charAt(i - 1) != ':' && line.charAt(i + 1) != ')' || line.charAt(i) == ':') break;
                --i;
            }
            if (i >= 0 && line.charAt(i) == '(') {
                while (i > 0 && line.charAt(i) != ' ') {
                    --i;
                }
                String message = line.substring(i, line.length());
                SwingUtilities.invokeLater(new s.MessageDisplayer(message, false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void callCompletionGoto() {
        int car = this.textArea.getCaretPosition();
        int line = this.getCompletionLineNumber(car);
        DispatchData ndata = new DispatchData(this.data, (Component)this);
        XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxcgoto" + line, ndata);
        Dispatch.dispatch(receipt, ndata);
    }

    public void keyPressed(KeyEvent e) {
        boolean searchFlag;
        char key = e.getKeyChar();
        int code = e.getKeyCode();
        int mod = e.getModifiers();
        boolean bl = searchFlag = code == 9;
        if (code != 38 && code != 40 && code != 224 && code != 225 && code != 33 && code != 34 && code != 37 && code != 39 && code != 36 && code != 35) {
            e.consume();
        }
        if (code == 10) {
            int car = this.textArea.getCaretPosition();
            int line = this.getCompletionLineNumber(car);
            this.setVisible(false);
            this.displayProfileIfShouldBeDisplayed();
            DispatchData ndata = new DispatchData(this.data, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcomplselect" + line, ndata);
            Dispatch.dispatch(receipt, ndata);
        } else if (code == 32 && (e.getModifiers() & 2) != 0) {
            this.closeDialog();
            s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            CompletionDialog.completion(s.view);
        } else if (code == 32) {
            this.callCompletionGoto();
        } else if (code == 8) {
            if (this.history.size() > 1) {
                int oldCaret = ((HistoryElem)this.history.getFirst()).selection.length();
                this.history.removeFirst();
                int newCaret = ((HistoryElem)this.history.getFirst()).selection.length();
                this.showSelection();
                if (newCaret < oldCaret) {
                    s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
                    --this.insertOffset;
                    s.getBuffer().remove(this.insertOffset, 1);
                }
            }
        } else if (Character.isLetterOrDigit(key) || key == '_' || key == '$' || searchFlag) {
            String sel;
            int car = ((HistoryElem)this.history.getFirst()).caret;
            String nsel = sel = ((HistoryElem)this.history.getFirst()).selection;
            if (searchFlag) {
                ++car;
            } else {
                nsel = sel + key;
            }
            int ncar = this.text.toLowerCase().indexOf("\n" + nsel.toLowerCase(), car);
            if (ncar != -1) {
                String nnsel = this.text.substring(ncar + 1, ncar + nsel.length() + 1);
                this.history.addFirst(new HistoryElem(ncar, nnsel));
                this.showSelection();
                if (!searchFlag) {
                    s.insertCompletion(s.getBuffer(), this.insertOffset - sel.length(), nnsel);
                    ++this.insertOffset;
                }
            }
        } else if ("`~!@#$%^&*()_+|-=\\{}[]:\";'<>?,./".indexOf(key) != -1) {
            this.closeDialog();
            s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            s.getBuffer().insert(this.insertOffset, "" + key);
        } else if (code == 27) {
            this.closeDialog();
            if (mod == 1 || mod == 8) {
                s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    void showSelection() {
        int car = ((HistoryElem)this.history.getFirst()).caret;
        String sel = ((HistoryElem)this.history.getFirst()).selection;
        this.textArea.setCaretPosition(car);
        this.textArea.moveCaretPosition(car + sel.length());
    }

    void closeDialog() {
        this.setVisible(false);
    }

    public static void completion(View view) {
        if (s.activeProject != null) {
            s.completionIdBeforeCaret = s.getIdentifierBeforeCaret();
            s.completionIdAfterCaret = s.getIdentifierAfterCaret();
            XrefStringArray options = new XrefStringArray();
            options.add("-olcxcomplet");
            if (jEdit.getBooleanProperty((String)"xrefactory.completion-old-dialog")) {
                options.add("-jeditc1");
            }
            options.add("-maxcompls=" + Opt.maxCompletions());
            options.add("-olfqtcompletionslevel=" + jEdit.getIntegerProperty((String)"xrefactory.completion-fqtlevel", (int)1));
            if (Opt.completionLinkageCheck()) {
                options.add("-olchecklinkage");
            }
            if (Opt.completionAccessCheck()) {
                options.add("-olcheckaccess");
            }
            if (jEdit.getBooleanProperty((String)"xrefactory.completion-cases")) {
                options.add("-completioncasesensitive");
            }
            if (jEdit.getBooleanProperty((String)"xrefactory.completion-ins-parenthesis")) {
                options.add("-completeparenthesis");
            }
            DispatchData ndata = new DispatchData(s.xbTask, (Component)view);
            XrefCharBuffer receipt = ndata.xTask.callProcessOnFileNoSaves(options.toStringArray(true), ndata);
            Dispatch.dispatch(receipt, ndata);
        }
    }

    void setCompletionDialog(String completionList, DispatchData data) {
        String prefix = CompletionDialog.getPrefixOnCompletion();
        this.data = data;
        this.text = "\n" + completionList;
        this.textArea.setText(completionList);
        this.textArea.setBackground(jEdit.getColorProperty((String)"xrefactory.completion-bgcolor", (Color)s.completionBgDefaultColor));
        this.textArea.setForeground(jEdit.getColorProperty((String)"xrefactory.completion-fgcolor", (Color)Color.black));
        this.textArea.setFont(jEdit.getFontProperty((String)"xrefactory.completion-font", (Font)s.defaultFont));
        this.textArea.setEditable(true);
        this.insertOffset = s.getCaretPosition();
        this.insertFile = s.getFileName();
        this.pack();
        Dimension dim = this.getSize();
        if (dim.getHeight() > (double)Opt.completionDialogMaxHeight()) {
            dim.setSize(dim.getWidth() + 20.0, (double)Opt.completionDialogMaxHeight());
        }
        if (dim.getWidth() > (double)Opt.completionDialogMaxWidth()) {
            dim.setSize((double)Opt.completionDialogMaxWidth(), dim.getHeight() + 20.0);
        }
        this.setSize(dim);
        this.setLocation(s.recommendedLocation((Component)s.getTextArea()));
        s.moveOnScreen(this);
        this.x = this.getX();
        this.y = this.getY();
        this.history = new LinkedList();
        this.history.addFirst(new HistoryElem(0, prefix));
        this.showSelection();
        this.setVisible(true);
    }

    static void showCompletionDialog(String completionList, DispatchData data, int noFocus) {
        if (lastcDialog == null) {
            lastcDialog = new CompletionDialog();
        } else if (lastcDialog.isVisible()) {
            lastcDialog.setVisible(false);
            lastcDialog = new CompletionDialog();
        } else {
            lastcDialog = new CompletionDialog();
        }
        lastcDialog.setCompletionDialog(completionList, data);
    }

    CompletionDialog() {
        super((Frame)s.view, "");
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.setUndecorated(true);
        }
        this.textArea = new JTextArea();
        this.textArea.addKeyListener(this);
        this.textArea.addMouseListener(new CompletionMouseAdapter());
        this.textArea.addMouseMotionListener(new CompletionMouseMotionAdapter());
        this.scrollPane = new JScrollPane(this.textArea);
        this.setContentPane(this.scrollPane);
        this.enableEvents(8L);
    }

    static class HistoryElem {
        int caret;
        String selection;

        HistoryElem(int caret, String selection) {
            this.caret = caret;
            this.selection = selection;
        }
    }

    public class CompletionMouseMotionAdapter
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 8) != 0) {
                int cx = e.getX();
                int cy = e.getY();
                int dx = cx - CompletionDialog.this.mx;
                int dy = cy - CompletionDialog.this.my;
                CompletionDialog.this.x += dx;
                CompletionDialog.this.y += dy;
                CompletionDialog.this.setLocation(CompletionDialog.this.x, CompletionDialog.this.y);
            }
        }
    }

    public class CompletionMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            CompletionDialog.this.mx = e.getX();
            CompletionDialog.this.my = e.getY();
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                CompletionDialog.this.callCompletionGoto();
            }
        }
    }
}

