/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.BrowserTopPanel;
import com.xrefactory.jedit.CompletionDialog;
import com.xrefactory.jedit.CompletionDialog3;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.DockableClassTree;
import com.xrefactory.jedit.ExtractMethodDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.OptionsForProjectsDialog;
import com.xrefactory.jedit.Push;
import com.xrefactory.jedit.RefactoringDialog;
import com.xrefactory.jedit.Refactorings;
import com.xrefactory.jedit.ResolutionDialog;
import com.xrefactory.jedit.XrefAbortException;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefErrorException;
import com.xrefactory.jedit.XrefException;
import com.xrefactory.jedit.XrefTreeNode;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

public class Dispatch {
    static String currentTag;
    static int attrLen;
    static int attrLine;
    static int attrCol;
    static int attrOffset;
    static int attrVal;
    static int attrLevel;
    static int attrNumber;
    static int attrBeep;
    static int attrSelected;
    static int attrMType;
    static int attrBase;
    static int attrDRefn;
    static int attrRefn;
    static int attrIndent;
    static int attrInterface;
    static int attrDefinition;
    static int attrTreeUp;
    static int attrContinue;
    static int attrNoFocus;
    static String attrTreeDeps;
    static String attrType;
    static String attrVClass;
    static String attrSymbol;
    static String stringVal;
    static String block;

    static void clearAttributes() {
        attrLen = 0;
        attrLine = 0;
        attrCol = 0;
        attrOffset = 0;
        attrVal = 0;
        attrLevel = 0;
        attrNumber = 0;
        attrBeep = 0;
        attrSelected = 0;
        attrMType = 0;
        attrBase = 0;
        attrDRefn = 0;
        attrRefn = 0;
        attrIndent = 0;
        attrInterface = 0;
        attrDefinition = 0;
        attrTreeUp = 0;
        attrNoFocus = 0;
        attrTreeDeps = null;
        attrType = null;
        attrVClass = null;
    }

    static void browseUrlIfConfirmed(String url, DispatchData data) {
        try {
            int confirm = 0;
            if (Opt.askBeforeBrowsingJavadoc()) {
                confirm = JOptionPane.showConfirmDialog(s.getProbableParent(data.callerComponent), "Browse URL: " + url + "?", "Confirmation", 0, 3);
            }
            if (confirm == 0) {
                s.browseUrl(url, false, s.getParentView(data.callerComponent));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void editorPreCheck(String str) throws XrefException {
        int caret;
        Buffer buffer = s.getBuffer();
        String text = buffer.getText(caret = s.getCaretPosition(), str.length());
        if (!text.equals(str)) {
            throw new XrefException("expecting string " + str + " at this place, probably not updated references?");
        }
    }

    public static void editorReplace(String str, String with) throws XrefException {
        int caret;
        Buffer buffer = s.getBuffer();
        String text = buffer.getText(caret = s.getCaretPosition(), str.length());
        if (!text.equals(str)) {
            throw new XrefException("should replace " + str + " with " + with + ", but find " + text + " on this place");
        }
        buffer.remove(caret, str.length());
        buffer.insert(caret, with);
    }

    static void protocolCheckEq(String s1, String s2) throws Exception {
        if (!s1.equals(s2)) {
            throw new XrefException("Internal protocol error, got '" + s1 + "' while expecting '" + s2 + "'");
        }
    }

    public static int skipMyXmlIdentifier(XrefCharBuffer ss, int i, int len) {
        char c = ss.buf[i];
        while (i < len && (Character.isLetterOrDigit(c) || c == '-')) {
            c = ss.buf[++i];
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    public static int skipAttribute(XrefCharBuffer ss, int i, int len) {
        block4: {
            c = ss.buf[i];
            if (c != '\"') ** GOTO lbl11
            c = ' ';
            while (i < len && c != '\"' && c != '\n') {
                c = ss.buf[++i];
            }
            if (i >= len || c != 34) break block4;
            ++i;
            break block4;
lbl-1000:
            // 1 sources

            {
                c = ss.buf[++i];
lbl11:
                // 2 sources

                ** while (i < len && c != '>' && !Character.isWhitespace((char)c))
            }
        }
        return i;
    }

    public static String unquote(String a) {
        int len = a.length();
        if (len >= 2 && a.charAt(0) == '\"' && a.charAt(len - 1) == '\"') {
            return a.substring(1, len - 1);
        }
        return a;
    }

    public static String getContext(XrefCharBuffer ss, int i, int len) {
        int j = i + 20;
        String suffix = "";
        if (j >= len) {
            j = len;
        } else {
            suffix = " ...";
        }
        return ss.substring(i, j) + suffix;
    }

    public static int parseXmlTag(XrefCharBuffer ss, int i, int len) throws Exception {
        if ((i = s.skipBlank(ss, i, len)) >= len) {
            throw new XrefException("parsing beyond end of communication string");
        }
        if (ss.buf[i] != '<') {
            throw new XrefException("tag does not start with '<' (" + Dispatch.getContext(ss, i, len) + ")");
        }
        int j = ++i;
        if (ss.buf[i] == '/') {
            ++i;
        }
        i = Dispatch.skipMyXmlIdentifier(ss, i, len);
        currentTag = ss.substring(j, i);
        i = s.skipBlank(ss, i, len);
        while (ss.buf[i] != '>') {
            j = i;
            i = Dispatch.skipMyXmlIdentifier(ss, i, len);
            String attrib = ss.substring(j, i);
            if (ss.buf[i = s.skipBlank(ss, i, len)] != '=') {
                throw new XrefException("= expected after attribute " + attrib);
            }
            j = ++i;
            i = Dispatch.skipAttribute(ss, i, len);
            String attrval = ss.substring(j, i);
            if (attrib.equals("vcl")) {
                attrVClass = Dispatch.unquote(attrval);
            } else if (attrib.equals("base")) {
                attrBase = Integer.parseInt(attrval);
            } else if (attrib.equals("col")) {
                attrCol = Integer.parseInt(attrval);
            } else if (attrib.equals("definition")) {
                attrDefinition = Integer.parseInt(attrval);
            } else if (attrib.equals("drefn")) {
                attrDRefn = Integer.parseInt(attrval);
            } else if (attrib.equals("indent")) {
                attrIndent = Integer.parseInt(attrval);
            } else if (attrib.equals("interface")) {
                attrInterface = Integer.parseInt(attrval);
            } else if (attrib.equals("len")) {
                attrLen = Integer.parseInt(attrval);
            } else if (attrib.equals("line")) {
                attrLine = Integer.parseInt(attrval);
            } else if (attrib.equals("off")) {
                attrOffset = Integer.parseInt(attrval);
            } else if (attrib.equals("refn")) {
                attrRefn = Integer.parseInt(attrval);
            } else if (attrib.equals("selected")) {
                attrSelected = Integer.parseInt(attrval);
            } else if (attrib.equals("deps")) {
                attrTreeDeps = Dispatch.unquote(attrval);
            } else if (attrib.equals("up")) {
                attrTreeUp = Integer.parseInt(attrval);
            } else if (attrib.equals("mtype")) {
                attrMType = Integer.parseInt(attrval);
            } else if (attrib.equals("type")) {
                attrType = Dispatch.unquote(attrval);
            } else if (attrib.equals("beep")) {
                attrBeep = Integer.parseInt(attrval);
            } else if (attrib.equals("val")) {
                attrVal = Integer.parseInt(attrval);
            } else if (attrib.equals("lev")) {
                attrLevel = Integer.parseInt(attrval);
            } else if (attrib.equals("number")) {
                attrNumber = Integer.parseInt(attrval);
            } else if (attrib.equals("continue")) {
                attrContinue = Integer.parseInt(attrval);
            } else if (attrib.equals("nofocus")) {
                attrNoFocus = Integer.parseInt(attrval);
            } else if (attrib.equals("symbol")) {
                attrSymbol = Dispatch.unquote(attrval);
            } else if (s.debug) {
                throw new XrefException("unknown XML attribute '" + attrib + "'");
            }
            i = s.skipBlank(ss, i, len);
        }
        return ++i;
    }

    public static int parseXmlTagHandleMessages(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        boolean loop = true;
        while (loop) {
            Dispatch.clearAttributes();
            i = Dispatch.parseXmlTag(ss, i, len);
            if (currentTag.equals("error")) {
                i = Dispatch.dispatchError(ss, i, len, data);
            } else if (currentTag.equals("fatalError")) {
                i = Dispatch.dispatchFatalError(ss, i, len, data);
            } else if (currentTag.equals("warning")) {
                i = Dispatch.dispatchWarning(ss, i, len, data);
            } else if (currentTag.equals("debug-information")) {
                i = Dispatch.dispatchDebugMessage(ss, i, len, data);
            } else if (currentTag.equals("information")) {
                i = Dispatch.dispatchMessage(ss, i, len, data);
            } else if (currentTag.equals("bottom-information")) {
                i = Dispatch.dispatchBottomMessage(ss, i, len, data, "bottom-information");
            } else if (currentTag.equals("bottom-warning")) {
                i = Dispatch.dispatchBottomMessage(ss, i, len, data, "bottom-warning");
            } else if (currentTag.equals("ignore")) {
                i = Dispatch.dispatchIgnore(ss, i, len, data);
            } else if (currentTag.equals("license-error")) {
                i = Dispatch.dispatchLicenseError(ss, i, len, data);
            } else {
                loop = false;
            }
            if (!loop || (i = s.skipBlank(ss, i, len)) < len) continue;
            loop = false;
        }
        return i;
    }

    public static int dispatchError(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/error");
        throw new XrefErrorException(message);
    }

    public static int dispatchLicenseError(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/license-error");
        int answer = JOptionPane.showOptionDialog(s.getProbableParent(data.callerComponent), message, "Xrefactory Warning", 2, 2, null, new String[]{"Browse Url", "Continue"}, "Continue");
        if (answer == 0) {
            s.browseUrl("http://www.xref-tech.com/license.html", true, s.getParentView(data.callerComponent));
        }
        return i;
    }

    public static int dispatchFatalError(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/fatalError");
        throw new XrefErrorException(message);
    }

    public static int dispatchWarning(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/warning");
        JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), message, "Xrefactory Warning", 2);
        return i;
    }

    public static int dispatchMessage(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/information");
        JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), message, "Xrefactory Info", 1);
        return i;
    }

    public static int dispatchDebugMessage(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/debug-information");
        if (s.debug) {
            JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), message, "Xrefactory Debug Info", 1);
        }
        return i;
    }

    public static int dispatchBottomMessage(XrefCharBuffer ss, int i, int len, DispatchData data, String ctag) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        if (attrBeep != 0) {
            s.view.getToolkit().beep();
        }
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/" + ctag);
        SwingUtilities.invokeLater(new s.MessageDisplayer(message, true));
        return i;
    }

    public static int dispatchAskConfirmation(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/ask-confirmation");
        int confirm = JOptionPane.showConfirmDialog(s.getProbableParent(data.callerComponent), message, "Confirmation", 0, 2);
        if (confirm != 0) {
            throw new XrefAbortException();
        }
        return i;
    }

    public static int dispatchIgnore(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/ignore");
        return i;
    }

    public static int dispatchFileSaveAs(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String fname = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/file-save-as");
        s.getBuffer().save(s.view, fname, true);
        try {
            Thread.currentThread();
            Thread.sleep(35L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        VFSManager.waitForRequests();
        return i;
    }

    public static int dispatchMoveDirectory(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        String oldname = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/str");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        String newname = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/str");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/move-directory");
        int confirm = JOptionPane.showConfirmDialog(s.getProbableParent(data.callerComponent), "\tCan I move directory\n" + oldname + "\n\tto\n" + newname, "Confirmation", 0, 2);
        if (confirm == 0) {
            File ff = new File(oldname);
            ff.renameTo(new File(newname));
        }
        return i;
    }

    public static int dispatchMoveFileAs(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String fname = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/file-move-as");
        File ff = new File(fname);
        ff.getParentFile().mkdirs();
        File oldfile = new File(s.getBuffer().getPath());
        oldfile.delete();
        if (s.getBuffer().save(s.view, fname, true)) {
            try {
                Thread.currentThread();
                Thread.sleep(35L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            VFSManager.waitForRequests();
            Buffer oldb = jEdit.getBuffer((String)oldfile.getAbsolutePath());
            if (oldb != null && oldb != s.getBuffer()) {
                jEdit.closeBuffer((View)s.view, (Buffer)oldb);
            }
            try {
                Thread.currentThread();
                Thread.sleep(15L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } else {
            throw new XrefException("can not move the file");
        }
        VFSManager.waitForRequests();
        return i;
    }

    public static int dispatchGoto(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        if (currentTag.equals("position-off")) {
            String path = ss.substring(i, i + attrLen);
            int offset = attrOffset;
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/position-off");
            s.moveToPosition(s.getParentView(data.callerComponent), path, offset);
        } else {
            Dispatch.protocolCheckEq(currentTag, "position-lc");
            String path = ss.substring(i, i + attrLen);
            int line = attrLine;
            int col = attrCol;
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/position-lc");
            s.moveToPosition(s.getParentView(data.callerComponent), path, line, col);
        }
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/goto");
        return i;
    }

    public static int dispatchPreCheck(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String str = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/precheck");
        Dispatch.editorPreCheck(str);
        return i;
    }

    public static int dispatchString(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        stringVal = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/str");
        return i;
    }

    public static int dispatchReplacement(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i = Dispatch.dispatchString(ss, i, len, data);
        String str = stringVal;
        i = Dispatch.dispatchString(ss, i, len, data);
        String with = stringVal;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/replacement");
        Dispatch.editorReplace(str, with);
        return i;
    }

    public static int dispatchDisplayResolution(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        boolean cont = attrContinue != 0;
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/display-resolution");
        new ResolutionDialog(message, attrMType, data, cont);
        return i;
    }

    public static int dispatchDisplayOrUpdateBrowser(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/display-or-update-browser");
        s.showAndUpdateBrowser(s.getParentView(data.callerComponent));
        return i;
    }

    public static int dispatchDisplayClassTree(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        XrefTreeNode[] tt = new XrefTreeNode[500];
        tt[0] = new XrefTreeNode("root", null, 0, 0, 0, false, false, false, false, false, false);
        i = Dispatch.dispatchParseOneSymbolClassHierarchy(ss, i, len, data, tt, "");
        Dispatch.protocolCheckEq(currentTag, "/display-class-tree");
        s.view.getDockableWindowManager().showDockableWindow("xrefactory.class-tree-viewer");
        DockableClassTree ctViewer = s.getClassTreeViewer(s.view);
        ctViewer.setTree(tt[0]);
        return i;
    }

    static int dispatchParseOneSymbolClassHierarchy(XrefCharBuffer ss, int i, int len, DispatchData data, XrefTreeNode[] tt, String symbol) throws Exception {
        tt[1] = new XrefTreeNode(symbol, tt[0], 0, 0, 0, false, false, false, true, false, false);
        Dispatch.clearAttributes();
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("class")) {
            String ctclass = ss.substring(i, i + attrLen);
            i += attrLen;
            int deep = attrIndent + 2;
            s.assertt(deep < 500);
            tt[deep] = new XrefTreeNode(ctclass, tt[deep - 1], attrLine, attrRefn, attrDRefn, attrBase == 1, attrSelected == 1, attrInterface == 1, false, attrDefinition == 1, false);
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/class");
            Dispatch.clearAttributes();
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        return i;
    }

    static int dispatchParseTreeDescription(XrefCharBuffer ss, int i, int len, DispatchData data, XrefTreeNode[] tt) throws Exception {
        tt[0] = new XrefTreeNode("root", null, 0, 0, 0, false, false, false, false, false, false);
        XrefTreeNode nonVirtuals = new XrefTreeNode("NOT MEMBER SYMBOLS", tt[0], 0, 0, 0, false, false, false, true, false, false);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("virtual-symbol") || currentTag.equals("symbol")) {
            String symbol = ss.substring(i, i + attrLen);
            i += attrLen;
            if (currentTag.equals("symbol")) {
                new XrefTreeNode(symbol, nonVirtuals, attrLine, attrRefn, attrDRefn, attrBase == 1, attrSelected == 1, attrInterface == 1, false, attrDefinition == 1, false);
                i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
                Dispatch.protocolCheckEq(currentTag, "/symbol");
                Dispatch.clearAttributes();
                i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
                continue;
            }
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/virtual-symbol");
            i = Dispatch.dispatchParseOneSymbolClassHierarchy(ss, i, len, data, tt, symbol);
        }
        if (nonVirtuals.subNodes.size() == 0) {
            tt[0].removeSubNode(nonVirtuals);
        }
        return i;
    }

    public static int dispatchSymbolResolution(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        XrefTreeNode[] tt = new XrefTreeNode[500];
        i = Dispatch.dispatchParseTreeDescription(ss, i, len, data, tt);
        Dispatch.protocolCheckEq(currentTag, "/resolution");
        BrowserTopPanel bpanel = s.getParentBrowserTopPanel(data.callerComponent);
        s.assertt(bpanel != null);
        bpanel.treePanel.xtree.setTree(tt[0]);
        return i;
    }

    public static int dispatchReferenceList(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        boolean firstFlag = true;
        XrefCharBuffer refs = new XrefCharBuffer();
        int crefn = attrVal;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("src-line")) {
            if (!firstFlag) {
                refs.append("\n");
            }
            firstFlag = false;
            int j = 0;
            while (j < attrRefn) {
                if (j != 0) {
                    refs.append("\n");
                }
                refs.append(ss, i, attrLen);
                ++j;
            }
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/src-line");
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        Dispatch.protocolCheckEq(currentTag, "/reference-list");
        BrowserTopPanel bpanel = s.getParentBrowserTopPanel(data.callerComponent);
        s.assertt(bpanel != null);
        bpanel.referencesPanel.reflist.setRefs(refs.toString(), crefn);
        return i;
    }

    public static int dispatchUpdateCurrentReference(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        int val = attrVal;
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/update-current-refn");
        BrowserTopPanel bpanel = s.getParentBrowserTopPanel(data.callerComponent);
        s.assertt(bpanel != null);
        bpanel.referencesPanel.reflist.setCurrentRef(val);
        return i;
    }

    public static int dispatchProgress(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/progress");
        return i;
    }

    public static int dispatchUpdateReport(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        i += attrLen;
        Dispatch.clearAttributes();
        i = Dispatch.parseXmlTag(ss, i, len);
        while (i < len && !currentTag.equals("/update-report")) {
            i += attrLen;
            Dispatch.clearAttributes();
            i = Dispatch.parseXmlTag(ss, i, len);
            if (!currentTag.equals("fatalError")) continue;
            i = Dispatch.dispatchFatalError(ss, i, len, data);
        }
        Dispatch.protocolCheckEq(currentTag, "/update-report");
        return i;
    }

    public static int dispatchVersionMismatch(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String taskVersion = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTag(ss, i, len);
        Dispatch.protocolCheckEq(currentTag, "/version-mismatch");
        s.checkVersionCorrespondance(taskVersion, data);
        return i;
    }

    public static int dispatchBrowseUrl(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/browse-url");
        Dispatch.browseUrlIfConfirmed(message, data);
        return i;
    }

    public static int dispatchSingleCompletion(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String completion = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/single-completion");
        int caret = s.getCaretPosition();
        s.insertCompletion(s.getBuffer(), caret, completion);
        return i;
    }

    public static int dispatchFqtCompletion(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String completion = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/fqt-completion");
        int caret = s.getCaretPosition();
        CompletionDialog.insertFqtCompletion(s.getBuffer(), caret, completion);
        return i;
    }

    public static int dispatchCompletionList(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        boolean firstFlag = true;
        XrefCharBuffer completions = new XrefCharBuffer();
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("cl")) {
            if (!firstFlag) {
                completions.append("\n");
            }
            firstFlag = false;
            completions.append(ss, i, attrLen);
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/cl");
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        Dispatch.protocolCheckEq(currentTag, "/completions");
        CompletionDialog.showCompletionDialog(completions.toString(), data, attrNoFocus);
        return i;
    }

    public static int dispatchFullCompletionList(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        int ci = 0;
        int max = attrNumber;
        CompletionDialog3 cd = CompletionDialog3.initCompletionDialog(data, max, attrNoFocus);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("cl")) {
            s.assertt(ci < max);
            cd.lns[ci] = new CompletionDialog3.LineData(cd.completions.bufi, cd.completions.bufi + attrVal, attrVClass);
            cd.completions.append(ss, i, attrLen);
            ++ci;
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/cl");
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        cd.lns[ci] = new CompletionDialog3.LineData(cd.completions.bufi, -1, "");
        Dispatch.protocolCheckEq(currentTag, "/full-completions");
        CompletionDialog3.showCompletionDialog();
        return i;
    }

    public static int dispatchAllCompletionsList(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        XrefCharBuffer completions = new XrefCharBuffer();
        completions.append(ss, i, attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/all-completions");
        CompletionDialog.showCompletionDialog(completions.toString(), data, attrNoFocus);
        return i;
    }

    public static int dispatchSymbolList(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        XrefCharBuffer symbols = new XrefCharBuffer();
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("str")) {
            symbols.append(ss, i, attrLen);
            symbols.append("\n");
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/str");
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        Dispatch.protocolCheckEq(currentTag, "/symbol-list");
        data.symbolList = symbols;
        return i;
    }

    public static int dispatchSetProject(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        data.info = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/set-project");
        return i;
    }

    public static int dispatchSetInfo(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        data.info = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/set-info");
        return i;
    }

    public static int dispatchNoProject(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String file = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        if (data.projectCreationAllowed) {
            Dispatch.protocolCheckEq(currentTag, "/no-project-found");
            int rr = JOptionPane.showConfirmDialog(s.getProbableParent(data.callerComponent), "No project for file " + file + ".\nCreate new project?", "No Project", 0);
            if (rr == 0) {
                OptionsForProjectsDialog od = new OptionsForProjectsDialog((JFrame)s.view, true);
            }
        }
        throw new XrefAbortException();
    }

    public static int dispatchNoSymbol(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String name = s.getIdentifierOnCaret();
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/no-symbol-found");
        new Push(new String[]{"-olcxpushname=" + name, "-olnodialog"}, data);
        return i;
    }

    public static int dispatchAvailableRefactorings(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        boolean firstFlag = true;
        Refactorings[] refactors = new Refactorings[300];
        int refactoringsi = 0;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        while (currentTag.equals("int")) {
            Refactorings rrr = Refactorings.getRefactoringFromCode(attrVal);
            if (rrr != null) {
                s.assertt(refactoringsi < 300);
                refactors[refactoringsi] = rrr;
                refactors[refactoringsi].param = ss.substring(i, i + attrLen);
                ++refactoringsi;
            }
            i += attrLen;
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
            Dispatch.protocolCheckEq(currentTag, "/int");
            i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        }
        Dispatch.protocolCheckEq(currentTag, "/available-refactorings");
        Refactorings[] refactorings = new Refactorings[refactoringsi];
        System.arraycopy(refactors, 0, refactorings, 0, refactoringsi);
        new RefactoringDialog(refactorings);
        return i;
    }

    public static int dispatchCopyBlock(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        int cc = s.getCaretPosition();
        block = s.getBuffer().getText(cc, cc + attrVal);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/copy-block");
        return i;
    }

    public static int dispatchCutBlock(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        Buffer buffer = s.getBuffer();
        int blen = buffer.getLength();
        int caret = s.getCaretPosition();
        if (caret + attrVal == blen + 1) {
            buffer.insert(blen, "\n");
        }
        block = buffer.getText(caret, attrVal);
        buffer.remove(caret, attrVal);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/cut-block");
        return i;
    }

    public static int dispatchPasteBlock(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        Buffer buffer = s.getBuffer();
        int caret = s.getCaretPosition();
        buffer.insert(caret, block);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/past-block");
        return i;
    }

    public static int dispatchKillBufferRemoveFile(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String message = ss.substring(i, i + attrLen);
        i += attrLen;
        int confirm = 0;
        confirm = JOptionPane.showConfirmDialog((Component)s.view, message, "Confirmation", 0, 3);
        if (confirm == 0) {
            Buffer buf = s.getBuffer();
            buf.save(s.view, null);
            new File(buf.getPath()).delete();
            jEdit.closeBuffer((View)s.view, (Buffer)buf);
        }
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/kill-buffer-remove-file");
        return i;
    }

    public static int dispatchIndent(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        Buffer buffer = s.getBuffer();
        int caret = s.getCaretPosition();
        int line = buffer.getLineOfOffset(caret);
        buffer.indentLines(line, line + attrVal - 1);
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/indent-block");
        return i;
    }

    public static int dispatchExtractDialog(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        String xtype = attrType;
        i += attrLen;
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        String invocation = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTag(ss, i, len);
        Dispatch.protocolCheckEq(currentTag, "/str");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        String theHead = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTag(ss, i, len);
        Dispatch.protocolCheckEq(currentTag, "/str");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "str");
        String theTail = ss.substring(i, i + attrLen);
        i += attrLen;
        i = Dispatch.parseXmlTag(ss, i, len);
        Dispatch.protocolCheckEq(currentTag, "/str");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "int");
        int targetLine = attrVal;
        i += attrLen;
        i = Dispatch.parseXmlTag(ss, i, len);
        Dispatch.protocolCheckEq(currentTag, "/int");
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        Dispatch.protocolCheckEq(currentTag, "/extraction-dialog");
        new ExtractMethodDialog(invocation, theHead, theTail, targetLine, xtype);
        return i;
    }

    public static int dispatchRecordAt(XrefCharBuffer ss, int i, int len, DispatchData data) throws Exception {
        int j = i = s.skipBlank(ss, i, len);
        while (ss.buf[i] != '<' && i < len) {
            ++i;
        }
        if (i != j && s.debug) {
            String unenclosed = ss.substring(j, i);
            JOptionPane.showMessageDialog((Component)s.view, "Unenclosed string\n" + unenclosed, "Xrefactory Error", 0);
        }
        if (j >= len) {
            throw new XrefException("unexpected end of communication");
        }
        Dispatch.clearAttributes();
        i = Dispatch.parseXmlTagHandleMessages(ss, i, len, data);
        if (i < len && !data.panic) {
            if (currentTag.equals("single-completion")) {
                i = Dispatch.dispatchSingleCompletion(ss, i, len, data);
            } else if (currentTag.equals("fqt-completion")) {
                i = Dispatch.dispatchFqtCompletion(ss, i, len, data);
            } else if (currentTag.equals("completions")) {
                i = Dispatch.dispatchCompletionList(ss, i, len, data);
            } else if (currentTag.equals("full-completions")) {
                i = Dispatch.dispatchFullCompletionList(ss, i, len, data);
            } else if (currentTag.equals("all-completions")) {
                i = Dispatch.dispatchAllCompletionsList(ss, i, len, data);
            } else if (currentTag.equals("symbol-list")) {
                i = Dispatch.dispatchSymbolList(ss, i, len, data);
            } else if (currentTag.equals("set-project")) {
                i = Dispatch.dispatchSetProject(ss, i, len, data);
            } else if (currentTag.equals("set-info")) {
                i = Dispatch.dispatchSetInfo(ss, i, len, data);
            } else if (currentTag.equals("no-project-found")) {
                i = Dispatch.dispatchNoProject(ss, i, len, data);
            } else if (currentTag.equals("no-symbol-found")) {
                i = Dispatch.dispatchNoSymbol(ss, i, len, data);
            } else if (currentTag.equals("update-current-refn")) {
                i = Dispatch.dispatchUpdateCurrentReference(ss, i, len, data);
            } else if (currentTag.equals("browse-url")) {
                i = Dispatch.dispatchBrowseUrl(ss, i, len, data);
            } else if (currentTag.equals("goto")) {
                i = Dispatch.dispatchGoto(ss, i, len, data);
            } else if (currentTag.equals("precheck")) {
                i = Dispatch.dispatchPreCheck(ss, i, len, data);
            } else if (currentTag.equals("replacement")) {
                i = Dispatch.dispatchReplacement(ss, i, len, data);
            } else if (currentTag.equals("display-or-update-browser")) {
                i = Dispatch.dispatchDisplayOrUpdateBrowser(ss, i, len, data);
            } else if (currentTag.equals("display-class-tree")) {
                i = Dispatch.dispatchDisplayClassTree(ss, i, len, data);
            } else if (currentTag.equals("display-resolution")) {
                i = Dispatch.dispatchDisplayResolution(ss, i, len, data);
            } else if (currentTag.equals("resolution")) {
                i = Dispatch.dispatchSymbolResolution(ss, i, len, data);
            } else if (currentTag.equals("reference-list")) {
                i = Dispatch.dispatchReferenceList(ss, i, len, data);
            } else if (currentTag.equals("ask-confirmation")) {
                i = Dispatch.dispatchAskConfirmation(ss, i, len, data);
            } else if (currentTag.equals("file-save-as")) {
                i = Dispatch.dispatchFileSaveAs(ss, i, len, data);
            } else if (currentTag.equals("file-move-as")) {
                i = Dispatch.dispatchMoveFileAs(ss, i, len, data);
            } else if (currentTag.equals("move-directory")) {
                i = Dispatch.dispatchMoveDirectory(ss, i, len, data);
            } else if (currentTag.equals("available-refactorings")) {
                i = Dispatch.dispatchAvailableRefactorings(ss, i, len, data);
            } else if (currentTag.equals("copy-block")) {
                i = Dispatch.dispatchCopyBlock(ss, i, len, data);
            } else if (currentTag.equals("cut-block")) {
                i = Dispatch.dispatchCutBlock(ss, i, len, data);
            } else if (currentTag.equals("past-block")) {
                i = Dispatch.dispatchPasteBlock(ss, i, len, data);
            } else if (currentTag.equals("kill-buffer-remove-file")) {
                i = Dispatch.dispatchKillBufferRemoveFile(ss, i, len, data);
            } else if (currentTag.equals("indent-block")) {
                i = Dispatch.dispatchIndent(ss, i, len, data);
            } else if (currentTag.equals("extraction-dialog")) {
                i = Dispatch.dispatchExtractDialog(ss, i, len, data);
            } else if (currentTag.equals("update-report")) {
                i = Dispatch.dispatchUpdateReport(ss, i, len, data);
            } else if (currentTag.equals("version-mismatch")) {
                i = Dispatch.dispatchVersionMismatch(ss, i, len, data);
            } else if (currentTag.equals("progress")) {
                i = Dispatch.dispatchProgress(ss, i, len, data);
            } else if (!currentTag.equals("sync")) {
                throw new XrefException("unknown XML Tag " + currentTag);
            }
        }
        return i;
    }

    public static void dispatch(XrefCharBuffer ss, DispatchData data) {
        if (s.debug) {
            System.err.println("Dispatching: " + ss);
        }
        int i = 0;
        int len = ss.length();
        try {
            i = s.skipBlank(ss, i, len);
            while (i < len && !data.panic) {
                i = Dispatch.dispatchRecordAt(ss, i, len, data);
                i = s.skipBlank(ss, i, len);
            }
        }
        catch (XrefAbortException e) {
            data.panic = true;
        }
        catch (XrefErrorException e) {
            if (s.debug) {
                e.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), e, "Xrefactory Error", 0);
            data.panic = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), e, "Xrefactory Internal Error", 0);
            e.printStackTrace();
            data.panic = true;
        }
    }

    public static String reportToHtml(XrefCharBuffer ss) {
        XrefCharBuffer res = new XrefCharBuffer();
        int i = 0;
        int len = ss.length();
        res.append("<html><pre>\n");
        try {
            while (i < len) {
                Dispatch.clearAttributes();
                i = Dispatch.parseXmlTag(ss, i, len);
                if (currentTag.equals("error") || currentTag.equals("fatalError") || currentTag.equals("warning")) {
                    res.append("<font color=red>");
                    int j = attrLen;
                    while (j > 0 && Character.isWhitespace(ss.buf[i + j - 1])) {
                        --j;
                    }
                    res.append(ss.substring(i, i + j));
                    res.append("</font>\n");
                    i += attrLen;
                    i = Dispatch.parseXmlTag(ss, i, len);
                } else if (currentTag.equals("information") || currentTag.equals("bottom-information")) {
                    res.append("<font color=gray>");
                    res.append(ss.substring(i, i + attrLen));
                    res.append("</font>\n");
                    i += attrLen;
                    i = Dispatch.parseXmlTag(ss, i, len);
                } else {
                    res.append(ss.substring(i, i + attrLen));
                    res.append("\n");
                    i += attrLen;
                }
                i = s.skipBlank(ss, i, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog((Component)s.view, "Problem while parsing report " + e, "Xrefactory Error", 0);
        }
        res.append("\n</pre></html>\n");
        if (s.debug) {
            System.err.println("HTML == \n" + res.toString());
        }
        return res.toString();
    }
}

