/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MoveDialog
extends JDialog {
    public String getFile() {
        return ((MovePanel)this.getContentPane()).tfile.getText();
    }

    public String getLine() {
        return ((MovePanel)this.getContentPane()).tline.getText();
    }

    public MoveDialog(String kind, boolean fieldMoving, String continuationOption, String contTestOption) {
        super((Frame)s.view, kind);
        MovePanel panel = new MovePanel(kind, fieldMoving, continuationOption, contTestOption);
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo((Component)s.view);
        this.setVisible(true);
        this.pack();
        this.repaint();
    }

    public static class MovePanel
    extends JPanel
    implements KeyListener,
    FocusListener {
        String continuationOption;
        String contTestOption;
        String stext = "";
        String sfile;
        int sline;
        int scaret;
        JTextField ssfile;
        JTextField ssline;
        JTextField tfile;
        JTextField tline;
        JTextField tfield;

        void actionContinue() {
            if (this.tfile.getText().equals("") || Integer.parseInt(this.tline.getText()) <= 0) {
                JOptionPane.showMessageDialog((Component)s.view, "Invalid target place. In order to set target position, move \nto the target place, invoke refactoring function and select \n'Set target for next moving refactoring' item.", "Xrefactory Error", 0);
            }
            DispatchData ndata = new DispatchData(s.xbTask, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessOnFileSingleOpt(this.contTestOption, ndata);
            Dispatch.dispatch(receipt, ndata);
            if (!s.panic) {
                s.getParentDialog(this).setVisible(false);
                s.targetFile = this.tfile.getText();
                s.targetLine = Integer.parseInt(this.tline.getText());
                s.moveToPosition(s.view, this.sfile, this.scaret);
                if (this.stext.equals(s.getTextArea().getText())) {
                    this.stext = "";
                    String fieldOpt = null;
                    if (this.tfield != null) {
                        fieldOpt = this.tfield.getText();
                    }
                    s.performMovingRefactoring(this.continuationOption, fieldOpt);
                } else {
                    JOptionPane.showMessageDialog((Component)s.view, "Source file was modified during target selection, please retry.", "Xrefactory Error", 0);
                }
            }
        }

        void actionCancel() {
            s.getParentDialog(this).setVisible(false);
            this.tfile.setText("");
            this.tline.setText("0");
        }

        void actionImport() {
            this.tfile.setText(s.getBuffer().getPath());
            this.tline.setText("" + (s.getTextArea().getCaretLine() + 1));
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                e.consume();
                this.actionCancel();
            } else if (code == 10) {
                e.consume();
                this.actionContinue();
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            s.getParentDialog(this).pack();
            s.getParentDialog(this).repaint();
        }

        MovePanel(String kind, boolean fieldMoving, String continuationOption, String contTestOption) {
            JComponent[] buttons = new JButton[]{new ButtonCancel(), new ButtonContinue()};
            this.continuationOption = continuationOption;
            this.contTestOption = contTestOption;
            this.sfile = s.getBuffer().getPath();
            this.ssfile = new JTextField(this.sfile);
            this.ssfile.setEditable(false);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                this.ssfile.setFocusable(false);
            }
            this.sline = s.getTextArea().getCaretLine() + 1;
            this.ssline = new JTextField("" + this.sline);
            this.ssline.setEditable(false);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                this.ssline.setFocusable(false);
            }
            this.scaret = s.getTextArea().getCaretPosition();
            this.stext = s.getTextArea().getText();
            this.tfile = new JTextField(s.targetFile);
            this.tfile.setEditable(false);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                this.tfile.setFocusable(false);
            }
            this.tline = new JTextField("" + s.targetLine);
            this.tline.setEditable(false);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                this.tline.setFocusable(false);
            }
            int i = 0;
            while (i < buttons.length) {
                buttons[i].addKeyListener(this);
                buttons[i].addFocusListener(this);
                ++i;
            }
            this.tfile.addKeyListener(this);
            this.tfile.addFocusListener(this);
            this.tline.addKeyListener(this);
            this.tline.addFocusListener(this);
            if (fieldMoving) {
                this.tfield = new JTextField("");
                this.tfield.setEditable(true);
                this.tfield.addKeyListener(this);
                this.tfield.addFocusListener(this);
            } else {
                this.tfield = null;
            }
            this.setLayout(new GridBagLayout());
            JPanel mainpanel = new JPanel();
            mainpanel.setLayout(new GridBagLayout());
            int py = 0;
            s.addGbcComponent(mainpanel, 0, py, 5, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 5, 1, 1, 1, 0, new JLabel("With current settings, Xrefactory will move definition"));
            s.addGbcComponent(mainpanel, 0, ++py, 5, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 1, py, 1, 1, 1, 1, 0, new JLabel("  from file :", 4));
            s.addGbcComponent(mainpanel, 2, py, 2, 1, 1, 1, 1, this.ssfile);
            s.addGbcComponent(mainpanel, 4, py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 1, py, 1, 1, 1, 1, 0, new JLabel("   and line :", 4));
            s.addGbcComponent(mainpanel, 2, py, 2, 1, 1000, 1, 1, this.ssline);
            s.addGbcComponent(mainpanel, 4, py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 5, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 1, py, 1, 1, 1, 1, 0, new JLabel("    to file :", 4));
            s.addGbcComponent(mainpanel, 2, py, 2, 1, 1, 1, 1, this.tfile);
            s.addGbcComponent(mainpanel, 4, py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 1, py, 1, 1, 1, 1, 0, new JLabel("    on line :", 4));
            s.addGbcComponent(mainpanel, 2, py, 2, 1, 1000, 1, 1, this.tline);
            s.addGbcComponent(mainpanel, 4, py, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(mainpanel, 0, ++py, 4, 1, 1, 1, 1, new JPanel());
            if (fieldMoving) {
                s.addGbcComponent(mainpanel, 2, ++py, 1, 1, 100, 1, 1, new JPanel());
                s.addGbcComponent(mainpanel, 0, ++py, 1, 1, 1, 1, 1, new JPanel());
                s.addGbcComponent(mainpanel, 1, py, 2, 1, 1000, 1, 2, new JLabel("Field linking target object from source object: ", 4));
                s.addGbcComponent(mainpanel, 3, py, 1, 1, 1000, 1, 1, this.tfield);
                s.addGbcComponent(mainpanel, 4, py, 1, 1, 1, 1, 1, new JPanel());
            }
            int y = 0;
            s.addGbcComponent(this, 0, y, buttons.length + 2, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, buttons.length + 2, 1, 1, 1, 1, mainpanel);
            s.addGbcComponent(this, 0, ++y, buttons.length + 2, 1, 1, 1, 1, new JPanel());
            s.addButtonLine(this, ++y, buttons, true);
            s.addGbcComponent(this, 0, ++y, buttons.length + 2, 1, 1, 1, 1, new JPanel());
        }

        class ButtonContinue
        extends JButton
        implements ActionListener {
            ButtonContinue() {
                super("Continue");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                MovePanel.this.actionContinue();
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                MovePanel.this.actionCancel();
            }
        }

        class ButtonImport
        extends JButton
        implements ActionListener {
            ButtonImport() {
                super("Import position from jEdit");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                MovePanel.this.actionImport();
            }
        }
    }
}

