/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.PathSelectionDialog;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewProjectDialog
extends JDialog {
    void init(Component parent, Options[] projects) {
        this.setContentPane(new NewProjectPanel(projects));
        this.setSize(600, 250);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    NewProjectDialog(Dialog parent, Options[] projects) {
        super(parent, "Create New Project");
        this.init(parent, projects);
    }

    NewProjectDialog(Frame parent, Options[] projects) {
        super(parent, "Create New Project");
        this.init(parent, projects);
    }

    public static class NewProjectPanel
    extends JPanel {
        public JTextField projectName;
        public JTextField sourceDirectory;
        public JTextField classPath;
        public JTextField sourcePath;
        public JCheckBox makeActive;
        public Options[] projects;
        static int newcounter = 0;

        NewProjectPanel(Options[] projects) {
            String initcp;
            String initdir;
            int y = -1;
            this.setLayout(new GridBagLayout());
            this.projects = projects;
            do {
                this.projectName = new JTextField("test" + newcounter++);
            } while (s.projectExists(this.projectName.getText(), projects));
            if (s.view == null) {
                initdir = "";
                initcp = "";
            } else {
                initdir = new File(s.view.getBuffer().getPath()).getParent();
                initcp = s.inferDefaultSourcePath();
            }
            this.sourceDirectory = new JTextField(initdir);
            this.classPath = new JTextField(initcp);
            this.sourcePath = new JTextField(initcp);
            this.makeActive = new JCheckBox("Become the active project");
            JComponent[] buttons = new JButton[]{new ButtonCancel(), new ButtonContinue()};
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 10, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 3, 1, 10, 10, 2, new JLabel("Creating New Project!", 0));
            s.addGbcComponent(this, 0, ++y, 3, 1, 10, 10, 2, new JLabel("with", 0));
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 10, 2, new JPanel());
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 2, new JLabel("Project Name: ", 4));
            s.addGbcComponent(this, 1, y, 2, 1, 1000, 1, 2, this.projectName);
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 2, new JLabel("Source directories: ", 4));
            s.addGbcComponent(this, 1, y, 1, 1, 1000, 1, 2, this.sourceDirectory);
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, new ButtonBrowseSource());
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 2, new JLabel("Classpath: ", 4));
            s.addGbcComponent(this, 1, y, 1, 1, 1000, 1, 2, this.classPath);
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, new ButtonBrowseClassPath());
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 2, new JLabel("Sourcepath: ", 4));
            s.addGbcComponent(this, 1, y, 1, 1, 1000, 1, 2, this.sourcePath);
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 2, new ButtonBrowseSourcePath());
            s.addGbcComponent(this, 1, ++y, 2, 1, 10, 10, 2, this.makeActive);
            s.addGbcComponent(this, 0, ++y, 1, 1, 10, 10, 2, new JPanel());
            s.addExtraButtonLine(this, 0, ++y, 6, 1, 1, 1, buttons, true);
        }

        class ButtonContinue
        extends JButton
        implements ActionListener {
            ButtonContinue() {
                super("Continue");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (s.projectExists(NewProjectPanel.this.projectName.getText(), NewProjectPanel.this.projects)) {
                    JOptionPane.showMessageDialog(s.getParentDialog(this), "Project " + NewProjectPanel.this.projectName.getText() + " yet exists", "Xrefactory Error", 0);
                } else if (!NewProjectPanel.this.projectName.getText().equals("")) {
                    s.getParentDialog(this).setVisible(false);
                }
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                NewProjectPanel.this.projectName.setText("");
                s.getParentDialog(this).setVisible(false);
            }
        }

        class ButtonBrowseSourcePath
        extends JButton
        implements ActionListener {
            ButtonBrowseSourcePath() {
                super("Browse");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog np = new PathSelectionDialog(s.getParentDialog(this), NewProjectPanel.this.sourcePath.getText());
                NewProjectPanel.this.sourcePath.setText(np.resultString);
            }
        }

        class ButtonBrowseClassPath
        extends JButton
        implements ActionListener {
            ButtonBrowseClassPath() {
                super("Browse");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog np = new PathSelectionDialog(s.getParentDialog(this), NewProjectPanel.this.classPath.getText());
                NewProjectPanel.this.classPath.setText(np.resultString);
            }
        }

        class ButtonBrowseSource
        extends JButton
        implements ActionListener {
            ButtonBrowseSource() {
                super("Browse");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog np = new PathSelectionDialog(s.getParentDialog(this), NewProjectPanel.this.sourceDirectory.getText());
                NewProjectPanel.this.sourceDirectory.setText(np.resultString);
            }
        }
    }
}

