/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefBrowserTreeCellRenderer;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefClassTreeCellRenderer;
import com.xrefactory.jedit.XrefTreeKeyAdapter;
import com.xrefactory.jedit.XrefTreeModel;
import com.xrefactory.jedit.XrefTreeMouseAdapter;
import com.xrefactory.jedit.XrefTreeMouseMotionAdapter;
import com.xrefactory.jedit.XrefTreeNode;
import com.xrefactory.jedit.XrefTreePath;
import com.xrefactory.jedit.XrefTreeSelectionListener;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;

public class XrefCtree
extends JTree {
    private static XrefTreeNode[] aa = new XrefTreeNode[500];
    DispatchData data;
    public XrefTreeNode tree;
    public XrefTreeNode active;
    boolean embeddedInBrowser;

    private void expandAndSelect(XrefTreeNode node, int index) {
        XrefCtree.aa[index] = node;
        XrefTreePath cpath = new XrefTreePath(aa, index + 1);
        if (node.selected) {
            this.addSelectionPath(cpath);
        }
        this.expandPath(cpath);
        Enumeration ee = node.children();
        if (ee.hasMoreElements()) {
            while (ee.hasMoreElements()) {
                this.expandAndSelect((XrefTreeNode)ee.nextElement(), index + 1);
            }
        }
    }

    public void expandAllAndSelect() {
        this.expandAndSelect(this.tree, 0);
    }

    private void expandUntilBestFit(XrefTreeNode node, int index) {
        XrefCtree.aa[index] = node;
        if (node.bestFit) {
            int i = 1;
            while (i <= index + 1) {
                XrefTreePath cpath = new XrefTreePath(aa, i);
                this.expandPath(cpath);
                ++i;
            }
        } else {
            Enumeration ee = node.children();
            while (ee.hasMoreElements()) {
                this.expandUntilBestFit((XrefTreeNode)ee.nextElement(), index + 1);
            }
        }
    }

    public void expandUntilBestFit() {
        this.expandUntilBestFit(this.tree, 0);
    }

    public void expandAndSelect() {
        if (this.embeddedInBrowser) {
            this.expandAndSelect(this.tree, 0);
        } else {
            this.expandUntilBestFit(this.tree, 0);
        }
    }

    public void selectUnselect(XrefTreeNode node, int index, boolean value) {
        XrefCtree.aa[index] = node;
        node.selected = value;
        Enumeration ee = node.children();
        while (ee.hasMoreElements()) {
            this.selectUnselect((XrefTreeNode)ee.nextElement(), index + 1, value);
        }
    }

    public void selectUnselectAll(boolean value) {
        this.selectUnselect(this.tree, 0, value);
        this.treeDidChange();
        String option = value ? "-olcxmenuall" : "-olcxmenunone";
        DispatchData ndata = new DispatchData(this.data, (Component)this);
        XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt(option, ndata);
        Dispatch.dispatch(receipt, ndata);
    }

    void callProcessOnTreeLine(String option) {
        DispatchData ndata = new DispatchData(this.data, (Component)this);
        XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt(option + this.active.printedOnLine, ndata);
        Dispatch.dispatch(receipt, ndata);
    }

    public void toggleSelection() {
        this.active.selected = !this.active.selected;
        this.callProcessOnTreeLine("-olcxmenuselect");
        this.treeDidChange();
    }

    public void setTree(XrefTreeNode tt) {
        super.setModel(new XrefTreeModel(tt));
        this.tree = tt;
        this.active = null;
        this.expandAndSelect();
        this.repaint();
    }

    XrefCtree(DispatchData data, boolean embeddedInBrowser) {
        this(new XrefTreeNode(), data, embeddedInBrowser);
    }

    XrefCtree(XrefTreeNode tt, DispatchData data, boolean embeddedInBrowser) {
        s.setupCtreeFontsAndColors();
        this.setBackground(s.ctBgColor);
        this.data = data;
        this.embeddedInBrowser = embeddedInBrowser;
        this.setTree(tt);
        this.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(1);
        this.setSelectionModel(sm);
        this.expandAndSelect();
        DefaultTreeCellRenderer renderer = embeddedInBrowser ? new XrefBrowserTreeCellRenderer() : new XrefClassTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setRootVisible(false);
        this.addMouseListener(new XrefTreeMouseAdapter(this));
        this.addMouseMotionListener(new XrefTreeMouseMotionAdapter(this));
        this.addKeyListener(new XrefTreeKeyAdapter());
        this.addTreeSelectionListener(new XrefTreeSelectionListener(this));
    }
}

