/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;

public class XrefSelectableLinesTextPanel
extends JTextArea {
    DispatchData data;
    int lineOffset;
    int lastSelectedLine = -1;
    String inspectOption;
    String result = "";

    void renewSelection() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            if (ln != this.lastSelectedLine) {
                this.lastSelectedLine = ln;
            }
            this.setCaretPosition(this.getLineEndOffset(ln) - 1);
            this.moveCaretPosition(this.getLineStartOffset(ln));
            this.getCaret().setSelectionVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void inspectLine() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            this.result = this.getText(this.getLineStartOffset(ln), this.getLineEndOffset(ln) - this.getLineStartOffset(ln) - 1);
            if (this.inspectOption != null && !this.inspectOption.equals("")) {
                DispatchData ndata = new DispatchData(this.data, (Component)this);
                XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt(this.inspectOption + (ln + this.lineOffset), ndata);
                Dispatch.dispatch(receipt, ndata);
                this.renewSelection();
            } else {
                s.getProbableParent(this).setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Dimension countPreferredSize() {
        int nlc = this.getLineCount();
        int height = nlc * this.getRowHeight();
        if (height >= 300) {
            return new Dimension(500, 300);
        }
        return new Dimension(500, height);
    }

    public int getCaretLineShiftOffset() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            return (ln + 1) * this.getRowHeight();
        }
        catch (Exception e) {
            return 0;
        }
    }

    XrefSelectableLinesTextPanel(String list, DispatchData data, String inspectOption, int lineOffset, int baseLine) {
        super(list);
        this.data = data;
        this.lineOffset = lineOffset;
        this.inspectOption = inspectOption;
        this.setEditable(false);
        this.setBackground(s.light_gray);
        XrefClassTreeMouseAdapter ma = new XrefClassTreeMouseAdapter();
        this.addMouseListener(ma);
        this.addKeyListener(ma);
        try {
            this.setCaretPosition(this.getLineStartOffset(baseLine));
        }
        catch (Exception ee) {
            // empty catch block
        }
    }

    XrefSelectableLinesTextPanel(String inspectOption) {
        this("", null, inspectOption, 1, 0);
    }

    class XrefClassTreeMouseAdapter
    extends MouseInputAdapter
    implements KeyListener {
        XrefClassTreeMouseAdapter() {
        }

        void moveSelection(MouseEvent e) {
            int y = e.getY();
            int rh = XrefSelectableLinesTextPanel.super.getRowHeight();
            try {
                XrefSelectableLinesTextPanel.this.setCaretPosition(XrefSelectableLinesTextPanel.this.getLineStartOffset(y / rh));
                XrefSelectableLinesTextPanel.this.renewSelection();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public void mouseClicked(MouseEvent e) {
            XrefSelectableLinesTextPanel.this.inspectLine();
        }

        public void mouseDragged(MouseEvent e) {
            this.moveSelection(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.moveSelection(e);
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                XrefSelectableLinesTextPanel.this.result = "";
                JDialog pd = s.getParentDialog(XrefSelectableLinesTextPanel.this);
                if (pd != null) {
                    pd.setVisible(false);
                }
            } else if (code == 10 || code == 32) {
                XrefSelectableLinesTextPanel.this.inspectLine();
            }
        }

        public void keyReleased(KeyEvent e) {
            XrefSelectableLinesTextPanel.this.renewSelection();
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

