/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Exit;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public class DITAOTFailTask
extends Exit {
    private String id = null;
    private Properties prop = null;

    public void setId(String identifier) {
        this.id = identifier;
    }

    public void setParams(String params) {
        StringTokenizer tokenizer = new StringTokenizer(params, ";");
        this.prop = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int pos = token.indexOf("=");
            this.prop.put(token.substring(0, pos), token.substring(pos + 1));
        }
    }

    public void execute() throws BuildException {
        this.initMessageFile();
        MessageBean msgBean = MessageUtils.getMessage(this.id, this.prop);
        this.setMessage(msgBean.toString());
        try {
            super.execute();
        }
        catch (BuildException ex) {
            throw new BuildException(msgBean.toString(), (Throwable)new DITAOTException(msgBean, null, msgBean.toString()));
        }
    }

    private void initMessageFile() {
        String messageFile = this.getProject().getProperty("args.message.file");
        if (!new File(messageFile).exists()) {
            MessageUtils.loadDefaultMessages();
            return;
        }
        if (!new File(messageFile).isAbsolute()) {
            messageFile = new File(this.getProject().getBaseDir(), messageFile).getAbsolutePath();
        }
        MessageUtils.loadMessages(messageFile);
    }
}

