/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.ListReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.DitaWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugAndFilterModule
implements AbstractPipelineModule {
    private static final String[] PROPERTY_UPDATE_LIST = new String[]{"user.input.file", "hreftargetslist", "conreflist", "hrefditatopiclist", "fullditatopiclist", "fullditamapandtopiclist", "conreftargetslist", "copytosourcelist", "copytotarget2sourcemaplist", "outditafileslist", "conrefpushlist", "keyreflist", "codereflist", "skipchunklist", "canditopicslist", "resourceonlylist"};
    public static String extName = null;
    private static String tempDir = "";
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private boolean xmlValidate = true;
    private String inputMap = null;
    private String ditaDir = null;
    private String inputDir = null;

    private static void updateProperty(String listName, Properties property) {
        StringBuffer result = new StringBuffer(1024);
        String propValue = property.getProperty(listName);
        StringTokenizer tokenizer = null;
        if (propValue == null || "".equals(propValue.trim())) {
            return;
        }
        tokenizer = new StringTokenizer(propValue, ",");
        while (tokenizer.hasMoreElements()) {
            String file = (String)tokenizer.nextElement();
            int equalIndex = file.indexOf("=");
            int fileExtIndex = file.lastIndexOf(".");
            if (fileExtIndex != -1 && ".ditamap".equalsIgnoreCase(file.substring(fileExtIndex))) {
                result.append(",").append(file);
                continue;
            }
            if (equalIndex == -1) {
                result.append(",").append(FileUtils.replaceExtName(file, extName));
                continue;
            }
            result.append(",");
            result.append(FileUtils.replaceExtName(file.substring(0, equalIndex), extName));
            result.append("=");
            result.append(FileUtils.replaceExtName(file.substring(equalIndex + 1), extName));
        }
        String list = result.substring(1);
        property.setProperty(listName, list);
        String[] files = list.split(",");
        String filename = "";
        filename = listName == "user.input.file" ? "user.input.file.list" : listName.substring(0, listName.lastIndexOf("list")) + ".list";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(tempDir, filename))));
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    bufferedWriter.write(files[i]);
                    if (i < files.length - 1) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.flush();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Content content;
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String ditavalFile = ((PipelineHashIO)input).getAttribute("ditaval");
        tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        String ext = ((PipelineHashIO)input).getAttribute("ditaext");
        this.ditaDir = ((PipelineHashIO)input).getAttribute("ditadir");
        String transtype = ((PipelineHashIO)input).getAttribute("transtype");
        this.inputDir = null;
        String filePathPrefix = null;
        ListReader listReader = new ListReader();
        LinkedList parseList = null;
        String string = extName = ext.startsWith(".") ? ext : "." + ext;
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        if (ditavalFile != null && !new File(ditavalFile).isAbsolute()) {
            ditavalFile = new File(baseDir, ditavalFile).getAbsolutePath();
        }
        listReader.read(null);
        parseList = (LinkedList)listReader.getContent().getCollection();
        this.inputDir = (String)listReader.getContent().getValue();
        this.inputMap = new File(this.inputDir + File.separator + listReader.getInputMap()).getAbsolutePath();
        this.outputSubjectScheme();
        if (!new File(this.inputDir).isAbsolute()) {
            this.inputDir = new File(baseDir, this.inputDir).getAbsolutePath();
        }
        DitaValReader filterReader = new DitaValReader();
        if (ditavalFile != null) {
            filterReader.read(ditavalFile);
            content = filterReader.getContent();
            FilterUtils.setFilterMap(filterReader.getFilterMap());
        } else {
            content = new ContentImpl();
        }
        try {
            String valueOfValidate = ((PipelineHashIO)input).getAttribute("validate");
            if (valueOfValidate != null) {
                this.xmlValidate = !"false".equalsIgnoreCase(valueOfValidate);
            }
            DitaWriter.initXMLReader(this.ditaDir, this.xmlValidate);
        }
        catch (SAXException e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        DitaWriter fileWriter = new DitaWriter();
        content.setValue(tempDir);
        fileWriter.setContent(content);
        fileWriter.setExtName(extName);
        fileWriter.setTranstype(transtype);
        if (this.inputDir != null) {
            filePathPrefix = this.inputDir + "|";
        }
        Map<String, Set<String>> dic = this.readMapFromXML("subject_scheme.dictionary");
        while (!parseList.isEmpty()) {
            String filename = (String)parseList.removeLast();
            Set<String> schemaSet = dic.get(filename);
            filterReader.reset();
            if (schemaSet != null) {
                Iterator<String> iter = schemaSet.iterator();
                while (iter.hasNext()) {
                    filterReader.loadSubjectScheme(FileUtils.resolveFile(tempDir, iter.next()) + ".subm");
                }
                if (ditavalFile != null) {
                    filterReader.filterReset();
                    filterReader.read(ditavalFile);
                    FilterUtils.setFilterMap(filterReader.getFilterMap());
                } else {
                    FilterUtils.setFilterMap(null);
                }
                fileWriter.setValidateMap(filterReader.getValidValuesMap());
                fileWriter.setDefaultValueMap(filterReader.getDefaultValueMap());
            } else if (ditavalFile != null) {
                FilterUtils.setFilterMap(filterReader.getFilterMap());
            } else {
                FilterUtils.setFilterMap(null);
            }
            if (!new File(this.inputDir, filename).exists()) continue;
            fileWriter.write(new StringBuffer().append(filePathPrefix).append(filename).toString());
        }
        this.updateList(tempDir);
        File xmlListFile = new File(tempDir, "dita.xml.properties");
        if (xmlListFile.exists()) {
            listReader.read(xmlListFile.getAbsolutePath());
        } else {
            listReader.read(new File(tempDir, "dita.list").getAbsolutePath());
        }
        this.performCopytoTask(tempDir, listReader.getCopytoMap());
        return null;
    }

    private Map<String, Set<String>> readMapFromXML(String filename) {
        File inputFile = new File(tempDir, filename);
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        if (!inputFile.exists()) {
            return graph;
        }
        Properties prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(inputFile);
            prop.loadFromXML(in);
            in.close();
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            graph.put(string, StringUtils.restoreSet(value, ","));
        }
        return graph;
    }

    private void outputSubjectScheme() throws DITAOTException {
        Map<String, Set<String>> graph = this.readMapFromXML("subrelation.xml");
        LinkedList<String> queue = new LinkedList<String>();
        HashSet<String> visitedSet = new HashSet<String>();
        Iterator<Map.Entry<String, Set<String>>> graphIter = graph.entrySet().iterator();
        if (graphIter.hasNext()) {
            Map.Entry<String, Set<String>> entry = graphIter.next();
            queue.offer(entry.getKey());
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new InternalEntityResolver(CatalogUtils.getCatalog(this.ditaDir)));
            while (!queue.isEmpty()) {
                String parent = (String)queue.poll();
                Set<String> children = graph.get(parent);
                if (children != null) {
                    queue.addAll(children);
                }
                if ("ROOT".equals(parent) || visitedSet.contains(parent)) continue;
                visitedSet.add(parent);
                String tmprel = FileUtils.getRelativePathFromMap(this.inputMap, parent);
                tmprel = FileUtils.resolveFile(tempDir, tmprel) + ".subm";
                Document parentRoot = null;
                parentRoot = !FileUtils.fileExists(tmprel) ? builder.parse(new InputSource(new FileInputStream(parent))) : builder.parse(new InputSource(new FileInputStream(tmprel)));
                if (children != null) {
                    for (String childpath : children) {
                        Document childRoot = builder.parse(new InputSource(new FileInputStream(childpath)));
                        this.mergeScheme(parentRoot, childRoot);
                        String rel = FileUtils.getRelativePathFromMap(this.inputMap, childpath);
                        rel = FileUtils.resolveFile(tempDir, rel) + ".subm";
                        this.generateScheme(rel, childRoot);
                    }
                }
                String rel = FileUtils.getRelativePathFromMap(this.inputMap, parent);
                rel = FileUtils.resolveFile(tempDir, rel) + ".subm";
                this.generateScheme(rel, parentRoot);
            }
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
            throw new DITAOTException(e);
        }
    }

    private void mergeScheme(Document parentRoot, Document childRoot) {
        LinkedList<Element> pQueue = new LinkedList<Element>();
        pQueue.offer(parentRoot.getDocumentElement());
        while (!pQueue.isEmpty()) {
            Node tmpnode;
            int i;
            Element target;
            Element pe = (Element)pQueue.poll();
            NodeList pList = pe.getChildNodes();
            for (int i2 = 0; i2 < pList.getLength(); ++i2) {
                Node node = pList.item(i2);
                if (node.getNodeType() != 1) continue;
                pQueue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !value.contains(" subjectScheme/subjectdef ")) continue;
            value = pe.getAttribute("keyref");
            if (!StringUtils.isEmptyString(value)) {
                target = this.searchForKey(childRoot.getDocumentElement(), value);
                if (target == null) continue;
                pList = pe.getChildNodes();
                for (i = 0; i < pList.getLength(); ++i) {
                    tmpnode = childRoot.importNode(pList.item(i), false);
                    if (tmpnode.getNodeType() == 1 && this.searchForKey(target, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                    target.appendChild(tmpnode);
                }
                continue;
            }
            value = pe.getAttribute("keys");
            if (StringUtils.isEmptyString(value) || (target = this.searchForKey(childRoot.getDocumentElement(), value)) == null) continue;
            pList = target.getChildNodes();
            for (i = 0; i < pList.getLength(); ++i) {
                tmpnode = parentRoot.importNode(pList.item(i), false);
                if (tmpnode.getNodeType() == 1 && this.searchForKey(pe, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                pe.appendChild(tmpnode);
            }
        }
    }

    private Element searchForKey(Element root, String key) {
        if (root == null || StringUtils.isEmptyString(key)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !value.contains(" subjectScheme/subjectdef ") || StringUtils.isEmptyString(value = pe.getAttribute("keys")) || !value.equals(key)) continue;
            return pe;
        }
        return null;
    }

    private void generateScheme(String filename, Document root) throws DITAOTException {
        try {
            FileOutputStream file = new FileOutputStream(new File(filename));
            StreamResult res = new StreamResult(file);
            DOMSource ds = new DOMSource(root);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.transform(ds, res);
            if (res.getOutputStream() != null) {
                res.getOutputStream().close();
            }
            if (file != null) {
                file.close();
            }
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
            throw new DITAOTException(e);
        }
    }

    private void performCopytoTask(String tempDir, Map<String, String> copytoMap) {
        for (Map.Entry<String, String> entry : copytoMap.entrySet()) {
            String copytoTarget = entry.getKey();
            String copytoSource = entry.getValue();
            File srcFile = new File(tempDir, copytoSource);
            File targetFile = new File(tempDir, copytoTarget);
            if (targetFile.exists()) {
                Properties prop = new Properties();
                prop.setProperty("%1", copytoTarget);
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTX064W", prop).toString());
                continue;
            }
            FileUtils.copyFile(srcFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(String tempDir) {
        Properties property = new Properties();
        FileOutputStream output = null;
        FileOutputStream xmlDitalist = null;
        try {
            property.loadFromXML(new FileInputStream(new File(tempDir, "dita.xml.properties")));
            for (int i = 0; i < PROPERTY_UPDATE_LIST.length; ++i) {
                DebugAndFilterModule.updateProperty(PROPERTY_UPDATE_LIST[i], property);
            }
            output = new FileOutputStream(new File(tempDir, "dita.list"));
            xmlDitalist = new FileOutputStream(new File(tempDir, "dita.xml.properties"));
            property.store(output, null);
            property.storeToXML(xmlDitalist, null);
            output.flush();
            xmlDitalist.flush();
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        finally {
            try {
                output.close();
                xmlDitalist.close();
            }
            catch (IOException e) {
                this.javaLogger.logException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalEntityResolver
    implements EntityResolver {
        private HashMap<String, String> catalogMap = null;

        public InternalEntityResolver(HashMap<String, String> map) {
            this.catalogMap = map;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (this.catalogMap.get(publicId) != null) {
                File dtdFile = new File(this.catalogMap.get(publicId));
                return new InputSource(dtdFile.getAbsolutePath());
            }
            if (this.catalogMap.get(systemId) != null) {
                File schemaFile = new File(this.catalogMap.get(systemId));
                return new InputSource(schemaFile.getAbsolutePath());
            }
            return null;
        }
    }
}

