/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.PropertiesWriter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenMapAndTopicListModule
implements AbstractPipelineModule {
    private Set<String> ditaSet = null;
    private Set<String> fullTopicSet = null;
    private Set<String> fullMapSet = null;
    private Set<String> hrefTopicSet = null;
    private Set<String> hrefWithIDSet = null;
    private Set<String> chunkTopicSet = null;
    private Set<String> hrefMapSet = null;
    private Set<String> conrefSet = null;
    private Set<String> coderefSet = null;
    private Set<String> imageSet = null;
    private Set<String> flagImageSet = null;
    private Set<String> htmlSet = null;
    private Set<String> hrefTargetSet = null;
    private Set<String> conrefTargetSet = null;
    private Set<String> copytoSourceSet = null;
    private Set<String> nonConrefCopytoTargetSet = null;
    private Set<String> ignoredCopytoSourceSet = null;
    private Set<String> subsidiarySet = null;
    private Set<String> relFlagImagesSet = null;
    private Map<String, String> copytoMap = null;
    private List<String> waitList = null;
    private List<String> doneList = null;
    private Set<String> outDitaFilesSet = null;
    private Set<String> conrefpushSet;
    private Set<String> keyrefSet = null;
    private Set<String> resourceOnlySet;
    private Map<String, String> keysDefMap = null;
    private String baseInputDir = null;
    private String tempDir = null;
    private String ditaDir = null;
    private String inputFile = null;
    private String ditavalFile = null;
    private int uplevels = 0;
    private String prefix = "";
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private GenListModuleReader reader = null;
    private boolean xmlValidate = true;
    private String relativeValue = null;
    private String formatRelativeValue = null;
    private String rootFile = null;
    private OutputStreamWriter keydef;
    private OutputStreamWriter schemekeydef;
    private OutputStreamWriter export;
    private Set<String> schemeSet;
    private Map<String, Set<String>> schemeDictionary = null;
    private String transtype;

    public GenMapAndTopicListModule() throws SAXException, ParserConfigurationException {
        this.ditaSet = new HashSet<String>(128);
        this.fullTopicSet = new HashSet<String>(128);
        this.fullMapSet = new HashSet<String>(128);
        this.hrefTopicSet = new HashSet<String>(128);
        this.hrefWithIDSet = new HashSet<String>(128);
        this.chunkTopicSet = new HashSet<String>(128);
        this.schemeSet = new HashSet<String>(128);
        this.hrefMapSet = new HashSet<String>(128);
        this.conrefSet = new HashSet<String>(128);
        this.imageSet = new HashSet<String>(128);
        this.flagImageSet = new LinkedHashSet<String>(128);
        this.htmlSet = new HashSet<String>(128);
        this.hrefTargetSet = new HashSet<String>(128);
        this.subsidiarySet = new HashSet<String>(16);
        this.waitList = new LinkedList<String>();
        this.doneList = new LinkedList<String>();
        this.conrefTargetSet = new HashSet<String>(128);
        this.nonConrefCopytoTargetSet = new HashSet<String>(128);
        this.copytoMap = new HashMap<String, String>();
        this.copytoSourceSet = new HashSet<String>(128);
        this.ignoredCopytoSourceSet = new HashSet<String>(128);
        this.outDitaFilesSet = new HashSet<String>(128);
        this.relFlagImagesSet = new LinkedHashSet<String>(128);
        this.conrefpushSet = new HashSet<String>(128);
        this.keysDefMap = new HashMap<String, String>();
        this.keyrefSet = new HashSet<String>(128);
        this.coderefSet = new HashSet<String>(128);
        this.schemeDictionary = new HashMap<String, Set<String>>();
        this.resourceOnlySet = new HashSet<String>(128);
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        try {
            this.parseInputParameters(input);
            GenListModuleReader.initXMLReader(this.ditaDir, this.xmlValidate, this.rootFile);
            this.parseFilterFile();
            this.addToWaitList(this.inputFile);
            this.processWaitList();
            this.updateBaseDirectory();
            this.refactoringResult();
            this.outputResult();
            this.keydef.write("</stub>");
            this.keydef.close();
            this.schemekeydef.write("</stub>");
            this.schemekeydef.close();
            this.export.write("</stub>");
            this.export.close();
        }
        catch (DITAOTException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    private void parseInputParameters(AbstractPipelineInput input) {
        File inFile = null;
        PipelineHashIO hashIO = (PipelineHashIO)input;
        String basedir = hashIO.getAttribute("basedir");
        String ditaInput = hashIO.getAttribute("inputmap");
        this.tempDir = hashIO.getAttribute("tempDir");
        this.ditaDir = hashIO.getAttribute("ditadir");
        this.ditavalFile = hashIO.getAttribute("ditaval");
        String valueOfValidate = hashIO.getAttribute("validate");
        this.transtype = ((PipelineHashIO)input).getAttribute("transtype");
        if (valueOfValidate != null) {
            this.xmlValidate = !"false".equalsIgnoreCase(valueOfValidate);
        }
        OutputUtils.setGeneratecopyouter(hashIO.getAttribute("generatecopyouter"));
        OutputUtils.setOutterControl(hashIO.getAttribute("outercontrol"));
        OutputUtils.setOnlyTopicInMap(hashIO.getAttribute("onlytopicinmap"));
        File path = new File(hashIO.getAttribute("outputdir"));
        if (path.isAbsolute()) {
            OutputUtils.setOutputDir(hashIO.getAttribute("outputdir"));
        } else {
            StringBuffer buff = new StringBuffer(hashIO.getAttribute("basedir")).append(File.separator).append(path);
            OutputUtils.setOutputDir(buff.toString());
        }
        inFile = new File(ditaInput);
        if (!inFile.isAbsolute()) {
            inFile = new File(basedir, ditaInput);
        }
        if (!new File(this.tempDir).isAbsolute()) {
            this.tempDir = new File(basedir, this.tempDir).getAbsolutePath();
        }
        if (!new File(this.ditaDir).isAbsolute()) {
            this.ditaDir = new File(basedir, this.ditaDir).getAbsolutePath();
        }
        if (this.ditavalFile != null && !new File(this.ditavalFile).isAbsolute()) {
            this.ditavalFile = new File(basedir, this.ditavalFile).getAbsolutePath();
        }
        this.baseInputDir = new File(inFile.getAbsolutePath()).getParent();
        this.rootFile = inFile.getAbsolutePath();
        this.inputFile = inFile.getName();
        try {
            this.keydef = new OutputStreamWriter(new FileOutputStream(new File(this.tempDir, "keydef.xml")));
            this.keydef.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.keydef.write("<stub>");
            this.schemekeydef = new OutputStreamWriter(new FileOutputStream(new File(this.tempDir, "schemekeydef.xml")));
            this.schemekeydef.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.schemekeydef.write("<stub>");
            this.export = new OutputStreamWriter(new FileOutputStream(new File(this.tempDir, "export.xml")));
            this.export.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.export.write("<stub>");
        }
        catch (FileNotFoundException e) {
            this.javaLogger.logException(e);
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
        OutputUtils.setInputMapPathName(inFile.getAbsolutePath());
    }

    private void processWaitList() throws DITAOTException {
        this.reader = new GenListModuleReader();
        this.reader.setTranstype(this.transtype);
        while (!this.waitList.isEmpty()) {
            this.processFile(this.waitList.remove(0));
        }
    }

    private void processFile(String currentFile) throws DITAOTException {
        File fileToParse;
        File file = new File(currentFile);
        if (file.isAbsolute()) {
            fileToParse = file;
            currentFile = FileUtils.getRelativePathFromMap(this.rootFile, currentFile);
        } else {
            fileToParse = new File(this.baseInputDir, currentFile);
        }
        String msg = null;
        Properties params = new Properties();
        params.put("%1", currentFile);
        try {
            fileToParse = fileToParse.getCanonicalFile();
            if (FileUtils.isValidTarget(currentFile.toLowerCase())) {
                this.reader.setCurrentDir(new File(currentFile).getParent());
                this.reader.parse(fileToParse);
            } else {
                Properties prop = new Properties();
                prop.put("%1", fileToParse);
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ021W", params).toString());
            }
            if (this.reader.isValidInput()) {
                this.processParseResult(currentFile);
                this.categorizeCurrentFile(currentFile);
            } else if (!currentFile.equals(this.inputFile)) {
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ021W", params).toString());
            }
        }
        catch (SAXParseException sax) {
            sax.printStackTrace();
            Exception inner = sax.getException();
            if (inner != null && inner instanceof DITAOTException) {
                System.out.println(inner.getMessage());
                throw (DITAOTException)inner;
            }
            if (currentFile.equals(this.inputFile)) {
                MessageBean msgBean = MessageUtils.getMessage("DOTJ012F", params);
                msg = MessageUtils.getMessage("DOTJ012F", params).toString();
                msg = new StringBuffer(msg).append(":").append(sax.getMessage()).toString();
                throw new DITAOTException(msgBean, sax, msg);
            }
            StringBuffer buff = new StringBuffer();
            msg = MessageUtils.getMessage("DOTJ013E", params).toString();
            buff.append(msg).append(Constants.LINE_SEPARATOR).append(sax.getMessage());
            this.javaLogger.logError(buff.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (currentFile.equals(this.inputFile)) {
                MessageBean msgBean = MessageUtils.getMessage("DOTJ012F", params);
                msg = MessageUtils.getMessage("DOTJ012F", params).toString();
                msg = new StringBuffer(msg).append(":").append(e.getMessage()).toString();
                throw new DITAOTException(msgBean, e, msg);
            }
            StringBuffer buff = new StringBuffer();
            msg = MessageUtils.getMessage("DOTJ013E", params).toString();
            buff.append(msg).append(Constants.LINE_SEPARATOR).append(e.getMessage());
            this.javaLogger.logError(buff.toString());
        }
        if (!this.reader.isValidInput() && currentFile.equals(this.inputFile)) {
            if (this.xmlValidate) {
                msg = MessageUtils.getMessage("DOTJ022F", params).toString();
                throw new DITAOTException(msg);
            }
            msg = MessageUtils.getMessage("DOTJ034F", params).toString();
            throw new DITAOTException(msg);
        }
        this.doneList.add(currentFile);
        this.reader.reset();
    }

    private void processParseResult(String currentFile) {
        String value;
        Iterator<String> iter = this.reader.getNonCopytoResult().iterator();
        Map<String, String> cpMap = this.reader.getCopytoMap();
        Map<String, String> kdMap = this.reader.getKeysDMap();
        while (iter.hasNext()) {
            String file = iter.next();
            this.categorizeResultFile(file);
            this.updateUplevels(file);
        }
        for (String key : cpMap.keySet()) {
            value = cpMap.get(key);
            if (this.copytoMap.containsKey(key)) {
                Properties prop = new Properties();
                prop.setProperty("%1", value);
                prop.setProperty("%2", key);
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTX065W", prop).toString());
                this.ignoredCopytoSourceSet.add(value);
                continue;
            }
            this.updateUplevels(key);
            this.copytoMap.put(key, value);
        }
        this.schemeSet.addAll(this.reader.getSchemeRefSet());
        for (String key : kdMap.keySet()) {
            value = kdMap.get(key);
            if (!this.keysDefMap.containsKey(key)) {
                this.updateUplevels(key);
                try {
                    this.keydef.write("<keydef ");
                    this.keydef.write("keys=\"" + key + "\" ");
                    this.keydef.write("href=\"" + value + "\" ");
                    this.keydef.write("source=\"" + currentFile + "\"/>");
                    this.keydef.write("\n");
                    this.keydef.flush();
                }
                catch (IOException e) {
                    this.javaLogger.logException(e);
                }
                this.keysDefMap.put(key, value + "(" + currentFile + ")");
            }
            if (!this.schemeSet.contains(currentFile)) continue;
            try {
                this.schemekeydef.write("<keydef ");
                this.schemekeydef.write("keys=\"" + key + "\" ");
                this.schemekeydef.write("href=\"" + value + "\" ");
                this.schemekeydef.write("source=\"" + currentFile + "\"/>");
                this.schemekeydef.write("\n");
                this.schemekeydef.flush();
            }
            catch (IOException e) {
                this.javaLogger.logException(e);
            }
        }
        this.hrefTargetSet.addAll(this.reader.getHrefTargets());
        this.hrefWithIDSet.addAll(this.reader.getHrefTopicSet());
        this.chunkTopicSet.addAll(this.reader.getChunkTopicSet());
        this.conrefTargetSet.addAll(this.reader.getConrefTargets());
        this.nonConrefCopytoTargetSet.addAll(this.reader.getNonConrefCopytoTargets());
        this.ignoredCopytoSourceSet.addAll(this.reader.getIgnoredCopytoSourceSet());
        this.subsidiarySet.addAll(this.reader.getSubsidiaryTargets());
        this.outDitaFilesSet.addAll(this.reader.getOutFilesSet());
        this.resourceOnlySet.addAll(this.reader.getResourceOnlySet());
        Set<String> hrfSet = this.reader.getHrefTargets();
        Set<String> children = null;
        if (this.reader.getSchemeSet() != null && this.reader.getSchemeSet().size() > 0) {
            children = this.schemeDictionary.get(currentFile);
            if (children == null) {
                children = new HashSet<String>();
            }
            children.addAll(this.reader.getSchemeSet());
            currentFile = currentFile.replace("\\", "/");
            this.schemeDictionary.put(currentFile, children);
            for (String filename : hrfSet) {
                children = this.schemeDictionary.get(filename = filename.replace("\\", "/"));
                if (children == null) {
                    children = new HashSet<String>();
                }
                children.addAll(this.reader.getSchemeSet());
                this.schemeDictionary.put(filename, children);
            }
        }
    }

    private void categorizeCurrentFile(String currentFile) {
        String lcasefn = currentFile.toLowerCase();
        this.ditaSet.add(currentFile);
        if (FileUtils.isTopicFile(currentFile)) {
            this.hrefTargetSet.add(currentFile);
        }
        if (this.reader.hasConaction()) {
            this.conrefpushSet.add(currentFile);
        }
        if (this.reader.hasConRef()) {
            this.conrefSet.add(currentFile);
        }
        if (this.reader.hasKeyRef()) {
            this.keyrefSet.add(currentFile);
        }
        if (this.reader.hasCodeRef()) {
            this.coderefSet.add(currentFile);
        }
        if (FileUtils.isDITATopicFile(lcasefn)) {
            this.fullTopicSet.add(currentFile);
            if (this.reader.hasHref()) {
                this.hrefTopicSet.add(currentFile);
            }
        }
        if (FileUtils.isDITAMapFile(lcasefn)) {
            this.fullMapSet.add(currentFile);
            if (this.reader.hasHref()) {
                this.hrefMapSet.add(currentFile);
            }
        }
    }

    private void categorizeResultFile(String file) {
        String lcasefn = null;
        String format = null;
        if (file.contains("|")) {
            lcasefn = file.substring(0, file.indexOf("|")).toLowerCase();
            format = file.substring(file.indexOf("|") + 1);
            file = file.substring(0, file.indexOf("|"));
        } else {
            lcasefn = file.toLowerCase();
        }
        if (FileUtils.isDITAFile(lcasefn) && (format == null || "dita".equalsIgnoreCase(format) || "ditamap".equalsIgnoreCase(format))) {
            this.addToWaitList(file);
        } else if (!FileUtils.isSupportedImageFile(lcasefn)) {
            this.htmlSet.add(file);
        }
        if (FileUtils.isSupportedImageFile(lcasefn)) {
            this.imageSet.add(file);
        }
        if (FileUtils.isHTMLFile(lcasefn)) {
            this.htmlSet.add(file);
        }
        if (FileUtils.isPDFFile(lcasefn)) {
            this.htmlSet.add(file);
        }
        if (FileUtils.isSWFile(lcasefn)) {
            this.htmlSet.add(file);
        }
    }

    private void updateUplevels(String file) {
        int lastIndex;
        if (file.contains("|")) {
            file = file.substring(0, file.indexOf("|"));
        }
        if ((lastIndex = FileUtils.removeRedundantNames(file).replaceAll("\\\\", "/").lastIndexOf("../")) != -1) {
            int newUplevels = lastIndex / 3 + 1;
            this.uplevels = newUplevels > this.uplevels ? newUplevels : this.uplevels;
        }
    }

    private void addToWaitList(String file) {
        if (this.doneList.contains(file) || this.waitList.contains(file)) {
            return;
        }
        this.waitList.add(file);
    }

    private void updateBaseDirectory() {
        this.baseInputDir = new File(this.baseInputDir).getAbsolutePath();
        for (int i = this.uplevels; i > 0; --i) {
            File file = new File(this.baseInputDir);
            this.baseInputDir = file.getParent();
            this.prefix = new StringBuffer(file.getName()).append(File.separator).append(this.prefix).toString();
        }
    }

    private String getUpdateLevels() {
        StringBuffer buff = new StringBuffer();
        for (int current = this.uplevels; current > 0; --current) {
            buff.append(".." + Constants.FILE_SEPARATOR);
        }
        return buff.toString();
    }

    private String formatRelativeValue(String value) {
        StringBuffer buff = new StringBuffer();
        if (value == null || value.length() == 0) {
            return "";
        }
        block13: for (int index = 0; index < value.length(); ++index) {
            char current = value.charAt(index);
            switch (current) {
                case '.': {
                    buff.append("\\.");
                    continue block13;
                }
                case '\\': {
                    buff.append("[\\\\|/]");
                    continue block13;
                }
                case '(': {
                    buff.append("\\(");
                    continue block13;
                }
                case ')': {
                    buff.append("\\)");
                    continue block13;
                }
                case '[': {
                    buff.append("\\[");
                    continue block13;
                }
                case ']': {
                    buff.append("\\]");
                    continue block13;
                }
                case '{': {
                    buff.append("\\{");
                    continue block13;
                }
                case '}': {
                    buff.append("\\}");
                    continue block13;
                }
                case '^': {
                    buff.append("\\^");
                    continue block13;
                }
                case '+': {
                    buff.append("\\+");
                    continue block13;
                }
                case '$': {
                    buff.append("\\$");
                    continue block13;
                }
                default: {
                    buff.append(current);
                }
            }
        }
        return buff.toString();
    }

    private void parseFilterFile() {
        if (this.ditavalFile != null) {
            DitaValReader ditaValReader = new DitaValReader();
            ditaValReader.read(this.ditavalFile);
            FilterUtils.setFilterMap(ditaValReader.getFilterMap());
            this.flagImageSet.addAll(ditaValReader.getImageList());
            this.relFlagImagesSet.addAll(ditaValReader.getRelFlagImageList());
        } else {
            FilterUtils.setFilterMap(null);
        }
    }

    private void refactoringResult() {
        this.handleConref();
        this.handleCopyto();
    }

    private void handleCopyto() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        HashSet<String> pureCopytoSources = new HashSet<String>(128);
        HashSet<String> totalCopytoSources = new HashSet<String>(128);
        for (String key : this.copytoMap.keySet()) {
            String value = this.copytoMap.get(key);
            if (!new File(this.baseInputDir + File.separator + this.prefix, value).exists()) continue;
            tempMap.put(key, value);
            if (!this.conrefSet.contains(value)) continue;
            this.conrefSet.add(key);
        }
        this.copytoMap = tempMap;
        this.ditaSet.addAll(this.copytoMap.keySet());
        this.fullTopicSet.addAll(this.copytoMap.keySet());
        totalCopytoSources.addAll(this.copytoMap.values());
        totalCopytoSources.addAll(this.ignoredCopytoSourceSet);
        for (String src : totalCopytoSources) {
            if (this.nonConrefCopytoTargetSet.contains(src) || this.copytoMap.keySet().contains(src)) continue;
            pureCopytoSources.add(src);
        }
        this.copytoSourceSet = pureCopytoSources;
        this.ditaSet.removeAll(pureCopytoSources);
        this.fullTopicSet.removeAll(pureCopytoSources);
    }

    private void handleConref() {
        HashSet<String> pureConrefTargets = new HashSet<String>(128);
        for (String target : this.conrefTargetSet) {
            if (this.nonConrefCopytoTargetSet.contains(target)) continue;
            pureConrefTargets.add(target);
        }
        this.conrefTargetSet = pureConrefTargets;
        this.ditaSet.removeAll(pureConrefTargets);
        this.fullTopicSet.removeAll(pureConrefTargets);
    }

    private void outputResult() throws DITAOTException {
        Properties prop = new Properties();
        PropertiesWriter writer = new PropertiesWriter();
        ContentImpl content = new ContentImpl();
        File outputFile = new File(this.tempDir, "dita.list");
        File xmlDitalist = new File(this.tempDir, "dita.xml.properties");
        File dir = new File(this.tempDir);
        HashSet<String> copytoSet = new HashSet<String>(128);
        HashSet<String> keysDefSet = new HashSet<String>(128);
        Iterator<Map.Entry<String, String>> iter = null;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        prop.put("user.input.dir", this.baseInputDir);
        prop.put("user.input.file", this.prefix + this.inputFile);
        prop.put("user.input.file.listfile", "usr.input.file.list");
        File inputfile = new File(this.tempDir, "usr.input.file.list");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(inputfile)));
            bufferedWriter.write(this.prefix + this.inputFile);
            bufferedWriter.flush();
        }
        catch (FileNotFoundException e) {
            this.javaLogger.logException(e);
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
        this.relativeValue = this.prefix;
        this.formatRelativeValue = this.formatRelativeValue(this.relativeValue);
        prop.put("tempdirToinputmapdir.relative.value", this.formatRelativeValue);
        prop.put("uplevels", this.getUpdateLevels());
        this.addSetToProperties(prop, "outditafileslist", this.outDitaFilesSet);
        this.addSetToProperties(prop, "fullditamapandtopiclist", this.ditaSet);
        this.addSetToProperties(prop, "fullditatopiclist", this.fullTopicSet);
        this.addSetToProperties(prop, "fullditamaplist", this.fullMapSet);
        this.addSetToProperties(prop, "hrefditatopiclist", this.hrefTopicSet);
        this.addSetToProperties(prop, "conreflist", this.conrefSet);
        this.addSetToProperties(prop, "imagelist", this.imageSet);
        this.addSetToProperties(prop, "flagimagelist", this.flagImageSet);
        this.addSetToProperties(prop, "htmllist", this.htmlSet);
        this.addSetToProperties(prop, "hreftargetslist", this.hrefTargetSet);
        this.addSetToProperties(prop, "canditopicslist", this.hrefWithIDSet);
        this.addSetToProperties(prop, "skipchunklist", this.chunkTopicSet);
        this.addSetToProperties(prop, "subjectschemelist", this.schemeSet);
        this.addSetToProperties(prop, "conreftargetslist", this.conrefTargetSet);
        this.addSetToProperties(prop, "copytosourcelist", this.copytoSourceSet);
        this.addSetToProperties(prop, "subtargetslist", this.subsidiarySet);
        this.addSetToProperties(prop, "conrefpushlist", this.conrefpushSet);
        this.addSetToProperties(prop, "keyreflist", this.keyrefSet);
        this.addSetToProperties(prop, "codereflist", this.coderefSet);
        this.addSetToProperties(prop, "resourceonlylist", this.resourceOnlySet);
        this.addFlagImagesSetToProperties(prop, "relflagimagelist", this.relFlagImagesSet);
        for (Map.Entry<String, String> entry : this.copytoMap.entrySet()) {
            copytoSet.add(entry.toString());
        }
        for (Map.Entry<String, String> entry : this.keysDefMap.entrySet()) {
            keysDefSet.add(entry.toString());
        }
        this.addSetToProperties(prop, "copytotarget2sourcemaplist", copytoSet);
        this.addSetToProperties(prop, "keylist", keysDefSet);
        content.setValue(prop);
        writer.setContent(content);
        writer.write(outputFile.getAbsolutePath());
        writer.writeToXML(xmlDitalist.getAbsolutePath());
        this.writeMapToXML(this.reader.getRelationshipGrap(), "subrelation.xml");
        this.writeMapToXML(this.schemeDictionary, "subject_scheme.dictionary");
        if (this.transtype.equals("eclipsehelp")) {
            File pluginIdFile = new File(this.tempDir, "pluginId.xml");
            DelayConrefUtils.getInstance().writeMapToXML(this.reader.getPluginMap(), pluginIdFile);
            StringBuffer result = this.reader.getResult();
            try {
                this.export.write(result.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeMapToXML(Map<String, Set<String>> m, String filename) {
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Set<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            String value = StringUtils.assembleString(entry.getValue(), ",");
            prop.setProperty(key, value);
        }
        File outputFile = new File(this.tempDir, filename);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            prop.storeToXML(os, null);
            os.close();
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
    }

    private void addSetToProperties(Properties prop, String key, Set<String> set) {
        String value = null;
        LinkedHashSet<String> newSet = new LinkedHashSet<String>(128);
        for (String file : set) {
            if (new File(file).isAbsolute()) {
                newSet.add(FileUtils.removeRedundantNames(file));
                continue;
            }
            int index = file.indexOf("=");
            if (index != -1) {
                String to = file.substring(0, index);
                String source = file.substring(index + 1);
                if ("keylist".equals(key)) {
                    String repStr = FileUtils.removeRedundantNames(new StringBuffer(this.prefix).append(to).toString()).replaceAll("\\\\", "/") + "=" + FileUtils.removeRedundantNames(new StringBuffer(this.prefix).append(source).toString()).replaceAll("\\\\", "/");
                    if (!"".equals(this.prefix)) {
                        String prefix1 = this.prefix.replace("\\", "/");
                        if (repStr.indexOf(prefix1) == -1) continue;
                        StringBuffer sb = new StringBuffer();
                        sb.append(repStr.substring(prefix1.length()));
                        sb.insert(sb.lastIndexOf("(") + 1, prefix1);
                        newSet.add(sb.toString());
                        continue;
                    }
                    newSet.add(repStr);
                    continue;
                }
                newSet.add(FileUtils.removeRedundantNames(new StringBuffer(this.prefix).append(to).toString()).replaceAll("\\\\", "/") + "=" + FileUtils.removeRedundantNames(new StringBuffer(this.prefix).append(source).toString()).replaceAll("\\\\", "/"));
                continue;
            }
            newSet.add(FileUtils.removeRedundantNames(new StringBuffer(this.prefix).append(file).toString()).replaceAll("\\\\", "/"));
        }
        String fileKey = key.substring(0, key.lastIndexOf("list")) + "file";
        prop.put(fileKey, key.substring(0, key.lastIndexOf("list")) + ".list");
        File list = new File(this.tempDir, prop.getProperty(fileKey));
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(list)));
            Iterator it = newSet.iterator();
            while (it.hasNext()) {
                bufferedWriter.write((String)it.next());
                if (!it.hasNext()) continue;
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            this.javaLogger.logException(e);
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
        value = StringUtils.assembleString(newSet, ",");
        prop.put(key, value);
        set.clear();
        newSet.clear();
    }

    private void addFlagImagesSetToProperties(Properties prop, String key, Set<String> set) {
        String value = null;
        LinkedHashSet<String> newSet = new LinkedHashSet<String>(128);
        for (String file : set) {
            if (new File(file).isAbsolute()) {
                newSet.add(FileUtils.removeRedundantNames(file));
                continue;
            }
            newSet.add(FileUtils.removeRedundantNames(new StringBuffer().append(file).toString()).replaceAll("\\\\", "/"));
        }
        String fileKey = key.substring(0, key.lastIndexOf("list")) + "file";
        prop.put(fileKey, key.substring(0, key.lastIndexOf("list")) + ".list");
        File list = new File(this.tempDir, prop.getProperty(fileKey));
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(list)));
            Iterator it = newSet.iterator();
            while (it.hasNext()) {
                bufferedWriter.write((String)it.next());
                if (!it.hasNext()) continue;
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        value = StringUtils.assembleString(newSet, ",");
        prop.put(key, value);
        set.clear();
        newSet.clear();
    }
}

